/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.jsgen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeJS;
import com.probejs.compiler.formatter.formatter.IFormatter;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.java.ClassInfo;
import com.probejs.jdoc.java.MethodInfo;
import com.probejs.jdoc.property.AbstractProperty;
import com.probejs.util.json.JArray;
import com.probejs.util.json.JObject;
import com.probejs.util.json.JPrimitive;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DocGenerationEventJS
extends EventJS {
    private final Map<String, List<Consumer<DocumentClass>>> transformers = new HashMap<String, List<Consumer<DocumentClass>>>();
    private final List<IFormatter> specialFormatters = new ArrayList<IFormatter>();
    private final List<Consumer<JsonObject>> snippets = new ArrayList<Consumer<JsonObject>>();

    public DocGenerationEventJS specialType(String typeName, List<Object> elements) {
        this.specialFormatters.add((indent, stepIndent) -> List.of("%stype %s = %s;".formatted(" ".repeat(indent), typeName, elements.stream().map(Object::toString).collect(Collectors.joining(" | ")))));
        return this;
    }

    public DocGenerationEventJS transformDocument(Class<?> clazz, Consumer<DocumentClass> transformer) {
        return this.transformByName(MethodInfo.getRemappedOrOriginalClass(clazz), transformer);
    }

    public DocGenerationEventJS transformByName(String clazz, Consumer<DocumentClass> transformer) {
        this.transformers.computeIfAbsent(clazz, s -> new ArrayList()).add(transformer);
        return this;
    }

    public DocumentClass getJavaClass(Class<?> clazz) {
        return DocumentClass.fromJava(ClassInfo.getOrCache(clazz));
    }

    public AbstractProperty<?> getProperty(JsonObject object) {
        return Serde.deserializeProperty(object);
    }

    public DocGenerationEventJS addSnippet(String name, List<Object> items) {
        return this.addSnippet(name, items, null);
    }

    public DocGenerationEventJS addSnippet(String name, List<Object> items, String desc) {
        this.snippets.add(resultJson -> {
            Object[] objectArray = new Object[1];
            objectArray[0] = items.stream().map(arg_0 -> ((Gson)ProbeJS.GSON).toJson(arg_0)).collect(Collectors.joining(","));
            resultJson.add(name, (JsonElement)JObject.create().add("prefix", JArray.create().add(new JPrimitive("@" + name))).add("body", new JPrimitive("${1|%s|}".formatted(objectArray))).ifThen(desc != null, o -> o.add("description", new JPrimitive(desc))).serialize());
        });
        return this;
    }

    public DocGenerationEventJS customSnippet(String type, List<String> prefixes, List<Object> body) {
        return this.customSnippet(type, prefixes, body, null);
    }

    public DocGenerationEventJS customSnippet(String type, List<String> prefixes, List<Object> body, String desc) {
        this.snippets.add(resultJson -> resultJson.add(type, (JsonElement)JObject.create().add("prefix", JArray.create().addAll(prefixes.stream().map(JPrimitive::new))).add("body", JArray.create().addAll(body.stream().map(Object::toString).map(JPrimitive::new))).ifThen(desc != null, o -> o.add("description", new JPrimitive(desc))).serialize()));
        return this;
    }

    @HideFromJS
    public Map<String, List<Consumer<DocumentClass>>> getTransformers() {
        return this.transformers;
    }

    @HideFromJS
    public List<IFormatter> getSpecialFormatters() {
        return this.specialFormatters;
    }

    @HideFromJS
    public List<Consumer<JsonObject>> getSnippets() {
        return this.snippets;
    }
}

