/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.recipe;

import com.probejs.compiler.formatter.formatter.IFormatter;
import com.probejs.jdoc.property.PropertyComment;
import com.probejs.recipe.component.FormatterRecipeKey;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.recipe.schema.JsonRecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.minecraft.SpecialRecipeSchema;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class FormatterRecipe
implements IFormatter {
    private final String name;
    private final RecipeNamespace namespace;

    public FormatterRecipe(String name, RecipeNamespace namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("%s%s: {".formatted(" ".repeat(indent), this.name));
        for (Map.Entry entry : this.namespace.entrySet()) {
            String recipeName = (String)entry.getKey();
            RecipeSchemaType recipe = (RecipeSchemaType)entry.getValue();
            if (recipe.schema == SpecialRecipeSchema.SCHEMA || recipe.schema == JsonRecipeSchema.SCHEMA) continue;
            for (RecipeConstructor recipeConstructor : recipe.schema.constructors().values()) {
                ArrayList comments = new ArrayList();
                String method = "%s%s(%s):%s".formatted(" ".repeat(indent + stepIndent), recipeName, Arrays.stream(recipeConstructor.keys()).filter(key -> !key.excluded).map(FormatterRecipeKey::new).peek(key -> comments.add(key.getComments(recipe))).map(IFormatter::formatFirst).collect(Collectors.joining(", ")), "Special.Recipes.%s%s".formatted(Util.snakeToTitle(recipeName), Util.snakeToTitle(this.namespace.name)));
                ArrayList<String> paramLines = new ArrayList<String>();
                for (PropertyComment comment : comments) {
                    paramLines.addAll(comment.getLines());
                }
                if (!paramLines.isEmpty()) {
                    PropertyComment params = new PropertyComment(paramLines.toArray(new String[0]));
                    lines.addAll(params.formatLines(indent + stepIndent));
                }
                lines.add(method);
            }
        }
        lines.add("%s}".formatted(" ".repeat(indent)));
        return lines;
    }

    public static IFormatter formatRecipeNamespaces() {
        return (indent, stepIndent) -> {
            Set serializerIds = KubeJSRegistries.recipeSerializers().getIds().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("%sclass DocumentedRecipes {".formatted(" ".repeat(indent)));
            for (Map.Entry entry : RecipeNamespace.getAll().entrySet()) {
                RecipeNamespace namespace;
                FormatterRecipe formatter;
                List<String> formattedRecipes;
                String name = (String)entry.getKey();
                if (!serializerIds.contains(name) || (formattedRecipes = (formatter = new FormatterRecipe(name, namespace = (RecipeNamespace)entry.getValue())).format(indent + stepIndent, stepIndent)).size() <= 2) continue;
                lines.addAll(formattedRecipes);
            }
            lines.add("%s}".formatted(" ".repeat(indent)));
            return lines;
        };
    }
}

