/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.rich;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.probejs.util.PlatformSpecial;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.lwjgl.opengl.GL11;

public class ImageHelper {
    public static RenderTarget init() {
        TextureTarget frameBuffer = new TextureTarget(32, 32, true, false);
        frameBuffer.m_83956_();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)frameBuffer.f_83915_, (int)frameBuffer.f_83916_, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        return frameBuffer;
    }

    public static NativeImage getFromItem(ItemStack stack, RenderTarget fbo) {
        fbo.m_83947_(true);
        ImageHelper.renderItem(stack, Minecraft.m_91087_().m_91291_());
        NativeImage image = ImageHelper.fromRenderTarget(fbo);
        fbo.m_83970_();
        return image;
    }

    public static NativeImage getFromFluid(Fluid fluid, RenderTarget fbo) {
        fbo.m_83947_(true);
        ImageHelper.renderFluid(fluid);
        NativeImage image = ImageHelper.fromRenderTarget(fbo);
        fbo.m_83970_();
        return image;
    }

    public static NativeImage fromRenderTarget(RenderTarget frame) {
        NativeImage img = new NativeImage(frame.f_83915_, frame.f_83916_, true);
        frame.m_83956_();
        img.m_85045_(0, false);
        img.m_85122_();
        frame.m_83963_();
        return img;
    }

    public static void renderItem(ItemStack itemStack, ItemRenderer itemRenderer) {
        Matrix4f backup = RenderSystem.m_157192_().m_27658_();
        Matrix4f projection = Matrix4f.m_162203_((float)0.0f, (float)16.0f, (float)0.0f, (float)16.0f, (float)-150.0f, (float)150.0f);
        Matrix4f modelView = Matrix4f.m_27653_((float)1.0E-4f, (float)1.0E-4f, (float)0.0f);
        projection.m_27644_(modelView);
        RenderSystem.m_157425_((Matrix4f)projection);
        itemRenderer.m_115123_(itemStack, 0, 0);
        RenderSystem.m_157425_((Matrix4f)backup);
    }

    public static void renderFluid(Fluid fluid) {
        TextureAtlasSprite sprite = PlatformSpecial.INSTANCE.get().getFluidSprite(fluid);
        Matrix4f backup = RenderSystem.m_157192_().m_27658_();
        Matrix4f projection = Matrix4f.m_162203_((float)0.0f, (float)16.0f, (float)0.0f, (float)16.0f, (float)-150.0f, (float)150.0f);
        Matrix4f modelView = Matrix4f.m_27653_((float)1.0E-4f, (float)1.0E-4f, (float)0.0f);
        projection.m_27644_(modelView);
        RenderSystem.m_157425_((Matrix4f)projection);
        ImageHelper.renderFluidSprite(sprite);
        RenderSystem.m_157425_((Matrix4f)backup);
    }

    public static void renderFluidSprite(TextureAtlasSprite sprite) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        PoseStack matrices = RenderSystem.m_157191_();
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_5752_();
        buffer.m_85982_(matrix, 0.0f, 16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_5752_();
        buffer.m_85982_(matrix, 16.0f, 16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_5752_();
        buffer.m_85982_(matrix, 16.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_5752_();
        tesselator.m_85914_();
    }
}

