/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.rich.item;

import com.probejs.util.json.JObject;
import com.probejs.util.json.JPrimitive;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.block.CropBlock;

public class ItemAttribute {
    private final ItemStack item;

    public ItemAttribute(ItemStack item) {
        this.item = item;
    }

    private String determineToolType() {
        Item itemRepr = this.item.m_41720_();
        if (itemRepr instanceof SwordItem) {
            return "sword";
        }
        if (itemRepr instanceof PickaxeItem) {
            return "pickaxe";
        }
        if (itemRepr instanceof ShovelItem) {
            return "shovel";
        }
        if (itemRepr instanceof AxeItem) {
            return "axe";
        }
        if (itemRepr instanceof HoeItem) {
            return "hoe";
        }
        if (itemRepr instanceof ShearsItem) {
            return "shears";
        }
        if (itemRepr instanceof TridentItem) {
            return "trident";
        }
        if (itemRepr instanceof BowItem) {
            return "bow";
        }
        if (itemRepr instanceof CrossbowItem) {
            return "crossbow";
        }
        if (itemRepr instanceof ShieldItem) {
            return "shield";
        }
        if (itemRepr instanceof ArmorItem) {
            return "armor";
        }
        return null;
    }

    public JObject serialize() {
        Item itemRepr;
        FoodProperties food;
        JObject object = JObject.create().add("id", new JPrimitive(this.item.kjs$getId())).add("localized", new JPrimitive(this.item.m_41786_().getString())).add("maxDamage", new JPrimitive(this.item.m_41776_())).add("maxStackSize", new JPrimitive(this.item.m_41741_()));
        String toolType = this.determineToolType();
        if (toolType != null) {
            object.add("toolType", new JPrimitive(toolType));
        }
        if ((food = (itemRepr = this.item.m_41720_()).m_41473_()) != null) {
            object.add("food", JObject.create().add("nutrition", new JPrimitive(food.m_38744_())).add("saturation", new JPrimitive(Float.valueOf(food.m_38745_()))).add("alwaysEdible", new JPrimitive(food.m_38747_())));
        }
        if (itemRepr instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)itemRepr;
            object.add("block", JObject.create().add("crop", new JPrimitive(blockItem.m_40614_() instanceof CropBlock)));
        }
        return object;
    }
}

