/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.rich.item;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.rich.ImageHelper;
import com.probejs.rich.item.ItemAttribute;
import com.probejs.rich.item.ItemTagAttribute;
import com.probejs.util.json.JArray;
import dev.latvian.mods.kubejs.registry.KubeJSRegistries;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RichItemCompiler {
    public static void compile() throws IOException {
        JArray itemArray = JArray.create().addAll(KubeJSRegistries.items().entrySet().stream().map(Map.Entry::getValue).map(Item::m_7968_).map(ItemAttribute::new).map(ItemAttribute::serialize));
        Path richFile = ProbePaths.WORKSPACE_SETTINGS.resolve("item-attributes.json");
        BufferedWriter writer = Files.newBufferedWriter(richFile, new OpenOption[0]);
        writer.write(ProbeJS.GSON.toJson((JsonElement)itemArray.serialize()));
        writer.close();
        JArray tagArray = JArray.create().addAll(Registry.f_122827_.m_203612_().map(Pair::getFirst).map(ItemTagAttribute::new).map(ItemTagAttribute::serialize));
        Path richTagFile = ProbePaths.WORKSPACE_SETTINGS.resolve("item-tag-attributes.json");
        BufferedWriter tagWriter = Files.newBufferedWriter(richTagFile, new OpenOption[0]);
        tagWriter.write(ProbeJS.GSON.toJson((JsonElement)tagArray.serialize()));
        tagWriter.close();
    }

    public static void render(List<Pair<ItemStack, Path>> items) throws IOException {
        RenderTarget frameBuffer = ImageHelper.init();
        for (Pair<ItemStack, Path> pair : items) {
            NativeImage image = ImageHelper.getFromItem((ItemStack)pair.getFirst(), frameBuffer);
            image.m_85066_((Path)pair.getSecond());
            image.close();
            frameBuffer.m_83954_(false);
        }
        frameBuffer.m_83930_();
    }

    public static List<Pair<ItemStack, Path>> resolve() {
        ArrayList<Pair<ItemStack, Path>> items = new ArrayList<Pair<ItemStack, Path>>();
        for (ItemStack itemStack : KubeJSRegistries.items().entrySet().stream().map(Map.Entry::getValue).map(Item::m_7968_).toList()) {
            String name;
            Path path = ProbePaths.RICH_ITEM.resolve(itemStack.kjs$getIdLocation().m_135827_());
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (path.resolve((name = itemStack.kjs$getIdLocation().m_135815_().replace("/", "_")) + ".png").toFile().exists()) continue;
            items.add((Pair<ItemStack, Path>)Pair.of((Object)itemStack, (Object)path.resolve(name + ".png")));
        }
        return items;
    }
}

