/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.util;

import com.probejs.ProbeJS;
import com.probejs.compiler.formatter.formatter.jdoc.FormatterType;
import com.probejs.jdoc.property.PropertyType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Util {
    public static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract,arguments,boolean,break,byte,case,catch,char,const,continue,debugger,default,delete,do,double,else,eval,false,final,finally,float,for,function,goto,if,implements,in,instanceof,int,interface,let,long,native,new,null,package,private,protected,public,return,short,static,switch,synchronized,this,throw,throws,transient,true,try,typeof,var,void,volatile,while,with,yield".split(",")));
    private static final Pattern CAMEL_CASE_MATCH = Pattern.compile("[A-Z][a-z0-9]*");
    private static final Pattern JS_IDENTIFIER_MATCH = Pattern.compile("[A-Za-z_$][A-Za-z0-9_$]*");

    public static <T> T tryOrDefault(TrySupplier<T> toEval, T defaultValue) {
        try {
            return toEval.get();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getCapitalized(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String snakeToTitle(String s) {
        return Arrays.stream(s.split("_")).map(Util::getCapitalized).collect(Collectors.joining());
    }

    public static String camelCaseToSnake(String s) {
        return CAMEL_CASE_MATCH.matcher(s).replaceAll("_$0").toLowerCase();
    }

    public static String snakeToCamelCase(String s) {
        String[] parts = s.split("_");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i == 0) {
                sb.append(parts[i]);
                continue;
            }
            sb.append(Util.getCapitalized(parts[i]));
        }
        return sb.toString();
    }

    public static String getSafeName(String s) {
        return !KEYWORDS.contains(s) && (JS_IDENTIFIER_MATCH.matcher(s).matches() || s.startsWith("[") && s.endsWith("]")) ? s : ProbeJS.GSON.toJson((Object)s);
    }

    public static String formatMaybeParameterized(Class<?> clazz) {
        if (clazz.getTypeParameters().length == 0) {
            return new FormatterType.Clazz(new PropertyType.Clazz(clazz.getName())).formatFirst();
        }
        return new FormatterType.Parameterized(new PropertyType.Parameterized(new PropertyType.Clazz(clazz.getName()), Collections.nCopies(clazz.getTypeParameters().length, new PropertyType.Clazz(Object.class.getName())))).formatFirst();
    }

    public static String indent(int num) {
        return " ".repeat(num);
    }

    public static interface TrySupplier<T> {
        public T get() throws Exception;
    }
}

