/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.block.entity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.yezon.theabyss.block.entity.base.AbyssContainerBlockEntity;
import net.yezon.theabyss.block.entity.base.TickableBlockEntity;
import net.yezon.theabyss.init.TheabyssModBlockEntities;
import net.yezon.theabyss.init.TheabyssModBlocks;
import net.yezon.theabyss.init.TheabyssModItems;
import net.yezon.theabyss.recipes.AllRecipeTypes;
import net.yezon.theabyss.recipes.impl.SomniumInfusingRecipe;
import net.yezon.theabyss.utils.ContainerAndScreenUtils;
import net.yezon.theabyss.utils.RecipeUtils;
import net.yezon.theabyss.world.inventory.InfuserMenu;
import org.jetbrains.annotations.Nullable;

public class SomniumInfuserBlockEntity
extends AbyssContainerBlockEntity
implements TickableBlockEntity {
    public static final int CONTAINER_SIZE = 7;
    private final int resultSlot = 6;
    public static final int DATA_SIZE = 2;
    public static final int DEFAULT_PROCESS_DURATION = 200;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)7, (Object)ItemStack.f_41583_);
    private int processDuration = 200;
    private int processTime = 0;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return pIndex == 0 ? SomniumInfuserBlockEntity.this.processTime : SomniumInfuserBlockEntity.this.processDuration;
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 2;
        }
    };

    public SomniumInfuserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((Supplier<? extends BlockEntityType<?>>)TheabyssModBlockEntities.SOMNIUM_INFUSER, pPos, pBlockState, 7);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return switch (pIndex) {
            case 0 -> pStack.m_150930_((Item)TheabyssModItems.SOMNIUM.get());
            case 1 -> pStack.m_150930_((Item)TheabyssModItems.LORAN_ENERGY.get());
            default -> pIndex != 6;
        };
    }

    @Override
    public void serverTick(Level level, BlockPos blockPos, BlockState state) {
        if (!this.canProcess()) {
            @Nullable SomniumInfusingRecipe recipe = (SomniumInfusingRecipe)RecipeUtils.getRecipeFor(level, AllRecipeTypes.SOMNIUM_INFUSING, this);
            if (recipe != null && this.canStackOutput(recipe)) {
                if (this.isIdle()) {
                    this.processTime = 1;
                    this.processDuration = recipe.getProcessDuration();
                } else if (this.processTime >= this.processDuration) {
                    this.processRecipe(recipe);
                } else {
                    ++this.processTime;
                }
            } else {
                this.resetTime();
            }
        } else {
            this.resetTime();
        }
        SomniumInfuserBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
    }

    private void processRecipe(SomniumInfusingRecipe recipe) {
        ItemStack result = recipe.m_5874_(this);
        if (((ItemStack)this.items.get(6)).m_41619_()) {
            super.m_6836_(6, result);
        } else {
            ((ItemStack)this.items.get(6)).m_41769_(result.m_41613_());
        }
        for (int i = 0; i < this.items.size() - 1; ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.hasCraftingRemainingItem()) {
                ItemStack remainingItem = itemStack.getCraftingRemainingItem();
                this.items.set(i, (Object)remainingItem);
                continue;
            }
            itemStack.m_41774_(1);
        }
        this.resetTime();
    }

    private boolean canStackOutput(SomniumInfusingRecipe recipe) {
        if (!((ItemStack)this.items.get(this.resultSlot)).m_41619_()) {
            ItemStack resultSlot;
            ItemStack resultItem = recipe.m_8043_();
            if (resultItem.m_150930_((resultSlot = this.m_8020_(this.resultSlot)).m_41720_())) {
                int maxItemStack = Math.min(resultSlot.m_41741_(), this.m_6893_());
                int remainSpace = maxItemStack - (resultSlot.m_41613_() + resultItem.m_41613_());
                return remainSpace > 0;
            }
            return false;
        }
        return true;
    }

    private void resetTime() {
        this.processTime = 0;
        this.processDuration = 200;
    }

    public boolean isIdle() {
        return this.processTime <= 0;
    }

    private boolean canProcess() {
        for (int i = 0; i < this.items.size() - 1; ++i) {
            if (!super.m_8020_(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public InfuserMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new InfuserMenu(pContainerId, pPlayerInventory, this, ContainerAndScreenUtils.createLevelAccess(this), this.containerData);
    }

    public Component m_5446_() {
        return ((Block)TheabyssModBlocks.SOMNIUM_INFUSER.get()).m_49954_();
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("processDuration", this.processDuration);
        pTag.m_128405_("processTime", this.processTime);
        super.m_183515_(pTag);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag) {
        this.processDuration = pTag.m_128451_("processDuration");
        this.processTime = pTag.m_128451_("processTime");
    }
}

