/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.block.entity.base;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbyssContainerBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    private final int containerSize;
    private LazyOptional<IItemHandler> itemHolder = this.createItemHolder();

    public AbyssContainerBlockEntity(Supplier<? extends BlockEntityType<?>> pType, BlockPos pPos, BlockState pBlockState, int containerSize) {
        super(pType.get(), pPos, pBlockState);
        this.containerSize = containerSize;
    }

    public int m_6643_() {
        return this.containerSize;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.getItems()) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.getItems());
    }

    public boolean m_6542_(Player pPlayer) {
        return true;
    }

    protected void loadAdditional(CompoundTag pTag) {
    }

    public void m_142466_(CompoundTag pTag) {
        this.printContainerDebug();
        this.m_6211_();
        ContainerHelper.m_18980_((CompoundTag)pTag, this.getItems());
        this.loadAdditional(pTag);
        super.m_142466_(pTag);
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public abstract NonNullList<ItemStack> getItems();

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.getItems().get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.getItems(), (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.getItems(), (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.getItems().set(pSlot, (Object)pStack);
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.itemHolder);
    }

    private LazyOptional<IItemHandler> createItemHolder() {
        return LazyOptional.of(() -> new InvWrapper((Container)this));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHolder.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHolder = this.createItemHolder();
    }

    private void printContainerDebug() {
        System.out.printf("container [%s] | contains [%s] %n", Integer.toHexString(this.getItems().hashCode()), this.getItems());
    }
}

