/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.data.recipes.recipebuilders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.data.recipes.recipebuilders.TheAbyssRecipeBuilder;
import net.yezon.theabyss.init.TheabyssModBlocks;
import net.yezon.theabyss.recipes.AllRecipeTypes;

public class MortarRecipeBuilder
extends TheAbyssRecipeBuilder {
    private final List<Ingredient> ingredients;

    protected MortarRecipeBuilder(ItemStack result, List<Ingredient> ingredients) {
        super(result, AllRecipeTypes.MORTAR_AND_PESTLE);
        this.ingredients = ingredients;
        Preconditions.checkState((ingredients.size() == 5 ? 1 : 0) != 0);
        super.m_126132_("has_mortar_and_pestle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)TheabyssModBlocks.MORTAR_AND_PESTLE.get()}));
    }

    public static void buildTwoInputs(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, ItemStack result, Ingredient bottle, Ingredient ingredient1, Ingredient ingredient2) {
        ResourceLocation alternative = recipeId != null ? new ResourceLocation(recipeId.m_135827_(), recipeId.m_135815_() + "_alternative") : TheabyssMod.location(RecipeBuilder.m_176493_((ItemLike)result.m_41720_()).m_135815_() + "_alternative");
        MortarRecipeBuilder.buildRecipe(consumer, alternative, result, ingredient2, ingredient1, bottle, ingredient1, ingredient2);
        MortarRecipeBuilder.buildRecipe(consumer, recipeId, result, ingredient1, ingredient2, bottle, ingredient2, ingredient1);
    }

    public static void buildOneInput(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, ItemStack result, Ingredient bottle, Ingredient ingredient) {
        MortarRecipeBuilder.buildRecipe(consumer, recipeId, result, ingredient, ingredient, bottle, ingredient, ingredient);
    }

    public static void build(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, ItemStack result, Ingredient bottle, Ingredient ingredient1, Ingredient ingredient2, Ingredient ingredient3, Ingredient ingredient4) {
        MortarRecipeBuilder.buildRecipe(consumer, recipeId, result, bottle, ingredient1, ingredient2, bottle, ingredient3, ingredient4);
    }

    private static void buildRecipe(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, ItemStack itemStack, Ingredient ... ingredients) {
        MortarRecipeBuilder.saveRecipe(new MortarRecipeBuilder(itemStack, List.of(ingredients)), consumer, recipeId);
    }

    @Override
    protected void toJson(JsonObject jsonObject) {
        JsonArray array = new JsonArray();
        for (Ingredient ingredient : this.ingredients) {
            array.add(ingredient.m_43942_());
        }
        jsonObject.add("ingredients", (JsonElement)array);
    }
}

