/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.data.recipes.recipebuilders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.data.recipes.recipebuilders.TheAbyssRecipeBuilder;
import net.yezon.theabyss.init.TheabyssModItems;
import net.yezon.theabyss.recipes.AllRecipeTypes;

public class SomniumInfusingRecipeBuilder
extends TheAbyssRecipeBuilder {
    private final List<Ingredient> ingredients;
    private final int processTime;

    protected SomniumInfusingRecipeBuilder(ItemStack result, List<Ingredient> ingredients) {
        this(result, ingredients, 200);
    }

    protected SomniumInfusingRecipeBuilder(ItemStack result, List<Ingredient> ingredients, int processTime) {
        super(result, AllRecipeTypes.SOMNIUM_INFUSING);
        this.processTime = processTime;
        Preconditions.checkState((ingredients.size() == 4 ? 1 : 0) != 0);
        this.ingredients = ingredients;
        super.m_126132_("has_somnium_infuser", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)TheabyssModItems.SOMNIUM_INFUSER.get()}));
    }

    public static void buildOneInput(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, RegistryObject<? extends ItemLike> result, Ingredient ingredient) {
        SomniumInfusingRecipeBuilder.build(consumer, recipeId, result, new Ingredient[]{ingredient, ingredient, ingredient, ingredient});
    }

    public static void buildTwoSidesInput(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, RegistryObject<? extends ItemLike> result, Ingredient ingredient1, Ingredient ingredient2) {
        ResourceLocation alternative = recipeId != null ? new ResourceLocation(recipeId.m_135827_(), recipeId.m_135815_() + "_alt") : TheabyssMod.location(result.getId() + "_alt");
        SomniumInfusingRecipeBuilder.build(consumer, alternative, result, new Ingredient[]{ingredient2, ingredient2, ingredient1, ingredient1});
        SomniumInfusingRecipeBuilder.build(consumer, recipeId, result, new Ingredient[]{ingredient1, ingredient1, ingredient2, ingredient2});
    }

    public static void buildOneInput(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, int processTime, RegistryObject<? extends ItemLike> result, Ingredient ingredient) {
        SomniumInfusingRecipeBuilder.build(consumer, recipeId, result, processTime, new Ingredient[]{ingredient, ingredient, ingredient, ingredient});
    }

    public static void buildTwoSidesInput(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, int processTime, RegistryObject<? extends ItemLike> result, Ingredient ingredient1, Ingredient ingredient2) {
        ResourceLocation alternative = recipeId != null ? new ResourceLocation(recipeId.m_135827_(), recipeId.m_135815_() + "_alt") : TheabyssMod.location(result.getId() + "_alt");
        SomniumInfusingRecipeBuilder.build(consumer, alternative, result, processTime, new Ingredient[]{ingredient2, ingredient2, ingredient1, ingredient1});
        SomniumInfusingRecipeBuilder.build(consumer, recipeId, result, processTime, new Ingredient[]{ingredient1, ingredient1, ingredient2, ingredient2});
    }

    public static void buildTwoInputs(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, RegistryObject<? extends ItemLike> result, Ingredient ingredient1, Ingredient ingredient2) {
        ResourceLocation alternative = recipeId != null ? new ResourceLocation(recipeId.m_135827_(), recipeId.m_135815_() + "_alt") : TheabyssMod.location(result.getId().m_135815_() + "_alt");
        SomniumInfusingRecipeBuilder.build(consumer, alternative, result, new Ingredient[]{ingredient2, ingredient1, ingredient2, ingredient1});
        SomniumInfusingRecipeBuilder.build(consumer, recipeId, result, new Ingredient[]{ingredient1, ingredient2, ingredient1, ingredient2});
    }

    public static void buildTwoInputs(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, int processTime, RegistryObject<? extends ItemLike> result, Ingredient ingredient1, Ingredient ingredient2) {
        ResourceLocation alternative = recipeId != null ? new ResourceLocation(recipeId.m_135827_(), recipeId.m_135815_() + "_alt") : TheabyssMod.location(result.getId().m_135815_() + "_alt");
        SomniumInfusingRecipeBuilder.build(consumer, alternative, result, processTime, new Ingredient[]{ingredient2, ingredient1, ingredient2, ingredient1});
        SomniumInfusingRecipeBuilder.build(consumer, recipeId, result, processTime, new Ingredient[]{ingredient1, ingredient2, ingredient1, ingredient2});
    }

    public static void build(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, Supplier<? extends ItemLike> result, Ingredient ... ingredients) {
        SomniumInfusingRecipeBuilder.build(consumer, recipeId, result, 200, ingredients);
    }

    public static void build(Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId, Supplier<? extends ItemLike> result, int processTime, Ingredient ... ingredients) {
        SomniumInfusingRecipeBuilder builder = new SomniumInfusingRecipeBuilder(new ItemStack(result.get()), Arrays.asList(ingredients), processTime);
        SomniumInfusingRecipeBuilder.saveRecipe(builder, consumer, recipeId);
    }

    @Override
    protected void toJson(JsonObject jsonObject) {
        JsonArray array = new JsonArray(4);
        for (Ingredient ingredient : this.ingredients) {
            array.add(ingredient.m_43942_());
        }
        jsonObject.add("ingredients", (JsonElement)array);
        jsonObject.addProperty("process_time", (Number)this.processTime);
    }
}

