/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.data.recipes.recipebuilders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.yezon.theabyss.TheabyssMod;
import net.yezon.theabyss.recipes.AbyssRecipeType;
import net.yezon.theabyss.utils.RecipeUtils;

public abstract class TheAbyssRecipeBuilder
implements RecipeBuilder {
    protected final Advancement.Builder advancementBuilder;
    private final ItemStack result;
    private final RecipeSerializer<?> recipeSerializer;

    protected TheAbyssRecipeBuilder(ItemStack result, AbyssRecipeType recipeSerializer) {
        this.result = result;
        this.advancementBuilder = Advancement.Builder.m_138353_();
        this.recipeSerializer = recipeSerializer.getSerializer();
    }

    public static void saveRecipe(RecipeBuilder recipeBuilder, Consumer<FinishedRecipe> consumer, @Nullable ResourceLocation recipeId) {
        if (recipeId == null) {
            recipeBuilder.m_176498_(consumer);
        } else {
            recipeBuilder.m_126140_(consumer, recipeId);
        }
    }

    public void m_176498_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        ResourceLocation recipeId = TheabyssMod.location(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.m_142372_())).m_135815_());
        this.m_126140_(pFinishedRecipeConsumer, recipeId);
    }

    public void m_176500_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, String recipePath) {
        this.m_126140_(pFinishedRecipeConsumer, TheabyssMod.location(recipePath));
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancementBuilder.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public ItemStack getRecipeResult() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new ImplementedFinishedRecipe(pRecipeId, this));
    }

    protected abstract void toJson(JsonObject var1);

    private record ImplementedFinishedRecipe(ResourceLocation recipeId, TheAbyssRecipeBuilder builder) implements FinishedRecipe
    {
        public void m_7917_(JsonObject pJson) {
            this.builder.toJson(pJson);
            pJson.add("result", (JsonElement)RecipeUtils.itemStackToJson(this.builder.getRecipeResult()));
        }

        public ResourceLocation m_6445_() {
            return TheabyssMod.location(this.getSerializerName() + this.recipeId.m_135815_());
        }

        public RecipeSerializer<?> m_6637_() {
            return this.builder.recipeSerializer;
        }

        public JsonObject m_5860_() {
            return this.builder.advancementBuilder.m_138400_();
        }

        public ResourceLocation m_6448_() {
            return TheabyssMod.location("recipes/" + this.getSerializerName() + this.recipeId.m_135815_());
        }

        private String getSerializerName() {
            return Objects.requireNonNull(ForgeRegistries.RECIPE_SERIALIZERS.getKey(this.m_6637_())).m_135815_() + "/";
        }
    }
}

