/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.yezon.theabyss.TheabyssMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheabyssModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheabyssMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TheabyssMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.SaveFD = message.data.SaveFD;
                    variables.SaveY = message.data.SaveY;
                    variables.SaveZ = message.data.SaveZ;
                    variables.BookSpawn = message.data.BookSpawn;
                    variables.SaveX = message.data.SaveX;
                    variables.SaveHP = message.data.SaveHP;
                    variables.SleepEvent = message.data.SleepEvent;
                    variables.Mana = message.data.Mana;
                    variables.WandAbility = message.data.WandAbility;
                    variables.RadioEvent = message.data.RadioEvent;
                    variables.AbyssCloak = message.data.AbyssCloak;
                    variables.ManaBarToggle = message.data.ManaBarToggle;
                    variables.ManaBlinkAnimation = message.data.ManaBlinkAnimation;
                    variables.ManaUpgrade = message.data.ManaUpgrade;
                    variables.ManaRegenUpgrade = message.data.ManaRegenUpgrade;
                    variables.SleepEvent2 = message.data.SleepEvent2;
                    variables.GetConfigVersion = message.data.GetConfigVersion;
                    variables.ArmorPotionLevel = message.data.ArmorPotionLevel;
                    variables.FearEffect = message.data.FearEffect;
                    variables.EnableSomnium = message.data.EnableSomnium;
                    variables.Prolog = message.data.Prolog;
                    variables.ManaCooldown = message.data.ManaCooldown;
                    variables.ManaDurability = message.data.ManaDurability;
                    variables.ManaDamage = message.data.ManaDamage;
                    variables.Playername = message.data.Playername;
                    variables.PlayerRep = message.data.PlayerRep;
                    variables.NightbladeY = message.data.NightbladeY;
                    variables.NightbladeX = message.data.NightbladeX;
                    variables.NightbladeZ = message.data.NightbladeZ;
                    variables.HomeY = message.data.HomeY;
                    variables.HomeZ = message.data.HomeZ;
                    variables.HomeX = message.data.HomeX;
                    variables.RingOfHome = message.data.RingOfHome;
                    variables.PocketPlayerZ = message.data.PocketPlayerZ;
                    variables.PocketPlayerY = message.data.PocketPlayerY;
                    variables.PocketPlayerX = message.data.PocketPlayerX;
                    variables.PocketDimension = message.data.PocketDimension;
                    variables.ClockX = message.data.ClockX;
                    variables.ClockY = message.data.ClockY;
                    variables.ClockZ = message.data.ClockZ;
                    variables.ClockActive = message.data.ClockActive;
                    variables.FoundBody = message.data.FoundBody;
                    variables.DestriyAfterLifeItem = message.data.DestriyAfterLifeItem;
                    variables.FireworkOnJoin = message.data.FireworkOnJoin;
                    variables.ParticlesOnDeath = message.data.ParticlesOnDeath;
                    variables.WalkParticles = message.data.WalkParticles;
                    variables.P3 = message.data.P3;
                    variables.P4 = message.data.P4;
                    variables.P5 = message.data.P5;
                    variables.P6 = message.data.P6;
                    variables.NetherX = message.data.NetherX;
                    variables.NetherY = message.data.NetherY;
                    variables.NetherZ = message.data.NetherZ;
                    variables.EndX = message.data.EndX;
                    variables.EndY = message.data.EndY;
                    variables.EndZ = message.data.EndZ;
                    variables.AbyssX = message.data.AbyssX;
                    variables.AbyssY = message.data.AbyssY;
                    variables.AbyssZ = message.data.AbyssZ;
                    variables.OverworldX = message.data.OverworldX;
                    variables.OverworldY = message.data.OverworldY;
                    variables.OverworldZ = message.data.OverworldZ;
                    variables.CrimsonCrystalResearch = message.data.CrimsonCrystalResearch;
                    variables.WarpedCrystalResearch = message.data.WarpedCrystalResearch;
                    variables.EnderCrystalResearch = message.data.EnderCrystalResearch;
                    variables.AbyssCrystalResearch = message.data.AbyssCrystalResearch;
                    variables.FrostCrystalResearch = message.data.FrostCrystalResearch;
                    variables.HollowCrystalResearch = message.data.HollowCrystalResearch;
                    variables.LPMMode = message.data.LPMMode;
                    variables.EnableManaBar = message.data.EnableManaBar;
                    variables.FirstJoin = message.data.FirstJoin;
                    variables.PX = message.data.PX;
                    variables.HudX = message.data.HudX;
                    variables.HudY = message.data.HudY;
                    variables.HasAbsorb = message.data.HasAbsorb;
                    variables.HasArmor = message.data.HasArmor;
                    variables.HasExtraHP = message.data.HasExtraHP;
                    variables.BarComp = message.data.BarComp;
                    variables.EmptySomnium = message.data.EmptySomnium;
                    variables.SomniumHandler = message.data.SomniumHandler;
                    variables.EternalAbyss = message.data.EternalAbyss;
                    variables.EA_Intro = message.data.EA_Intro;
                    variables.FriendMode = message.data.FriendMode;
                    variables.Infected = message.data.Infected;
                    variables.Freeze = message.data.Freeze;
                    variables.CavernaCrystalResearch = message.data.CavernaCrystalResearch;
                    variables.AurelCrystalResearch = message.data.AurelCrystalResearch;
                    variables.HolyPlayer = message.data.HolyPlayer;
                    variables.ConfigBook = message.data.ConfigBook;
                    variables.GetDimension = message.data.GetDimension;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double SaveFD = 0.0;
        public double SaveY = 0.0;
        public double SaveZ = 0.0;
        public boolean BookSpawn = false;
        public double SaveX = 0.0;
        public double SaveHP = 0.0;
        public boolean SleepEvent = false;
        public double Mana = 0.0;
        public String WandAbility = "";
        public boolean RadioEvent = false;
        public boolean AbyssCloak = false;
        public boolean ManaBarToggle = false;
        public boolean ManaBlinkAnimation = false;
        public double ManaUpgrade = 1.0;
        public double ManaRegenUpgrade = 0.0;
        public boolean SleepEvent2 = false;
        public String GetConfigVersion = "";
        public double ArmorPotionLevel = 0.0;
        public boolean FearEffect = true;
        public boolean EnableSomnium = true;
        public boolean Prolog = true;
        public double ManaCooldown = 1.0;
        public double ManaDurability = 1.0;
        public double ManaDamage = 0.0;
        public String Playername = "";
        public double PlayerRep = 0.0;
        public double NightbladeY = 0.0;
        public double NightbladeX = 0.0;
        public double NightbladeZ = 0.0;
        public double HomeY = 0.0;
        public double HomeZ = 0.0;
        public double HomeX = 0.0;
        public boolean RingOfHome = false;
        public double PocketPlayerZ = 0.0;
        public double PocketPlayerY = 0.0;
        public double PocketPlayerX = 0.0;
        public boolean PocketDimension = false;
        public double ClockX = 0.0;
        public double ClockY = 0.0;
        public double ClockZ = 0.0;
        public boolean ClockActive = false;
        public boolean FoundBody = false;
        public boolean DestriyAfterLifeItem = false;
        public boolean FireworkOnJoin = false;
        public boolean ParticlesOnDeath = false;
        public boolean WalkParticles = false;
        public boolean P3 = false;
        public boolean P4 = false;
        public boolean P5 = false;
        public boolean P6 = false;
        public double NetherX = 0.0;
        public double NetherY = 0.0;
        public double NetherZ = 0.0;
        public double EndX = 0.0;
        public double EndY = 0.0;
        public double EndZ = 0.0;
        public double AbyssX = 0.0;
        public double AbyssY = 0.0;
        public double AbyssZ = 0.0;
        public double OverworldX = 0.0;
        public double OverworldY = 0.0;
        public double OverworldZ = 0.0;
        public boolean CrimsonCrystalResearch = false;
        public boolean WarpedCrystalResearch = false;
        public boolean EnderCrystalResearch = false;
        public boolean AbyssCrystalResearch = false;
        public boolean FrostCrystalResearch = false;
        public boolean HollowCrystalResearch = false;
        public boolean LPMMode = false;
        public boolean EnableManaBar = false;
        public boolean FirstJoin = false;
        public boolean PX = false;
        public double HudX = 0.0;
        public double HudY = 0.0;
        public boolean HasAbsorb = false;
        public boolean HasArmor = false;
        public boolean HasExtraHP = false;
        public boolean BarComp = false;
        public boolean EmptySomnium = false;
        public boolean SomniumHandler = false;
        public boolean EternalAbyss = false;
        public boolean EA_Intro = false;
        public boolean FriendMode = false;
        public double Infected = 0.0;
        public double Freeze = 0.0;
        public boolean CavernaCrystalResearch = false;
        public boolean AurelCrystalResearch = false;
        public boolean HolyPlayer = false;
        public boolean ConfigBook = false;
        public String GetDimension = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("SaveFD", this.SaveFD);
            nbt.m_128347_("SaveY", this.SaveY);
            nbt.m_128347_("SaveZ", this.SaveZ);
            nbt.m_128379_("BookSpawn", this.BookSpawn);
            nbt.m_128347_("SaveX", this.SaveX);
            nbt.m_128347_("SaveHP", this.SaveHP);
            nbt.m_128379_("SleepEvent", this.SleepEvent);
            nbt.m_128347_("Mana", this.Mana);
            nbt.m_128359_("WandAbility", this.WandAbility);
            nbt.m_128379_("RadioEvent", this.RadioEvent);
            nbt.m_128379_("AbyssCloak", this.AbyssCloak);
            nbt.m_128379_("ManaBarToggle", this.ManaBarToggle);
            nbt.m_128379_("ManaBlinkAnimation", this.ManaBlinkAnimation);
            nbt.m_128347_("ManaUpgrade", this.ManaUpgrade);
            nbt.m_128347_("ManaRegenUpgrade", this.ManaRegenUpgrade);
            nbt.m_128379_("SleepEvent2", this.SleepEvent2);
            nbt.m_128359_("GetConfigVersion", this.GetConfigVersion);
            nbt.m_128347_("ArmorPotionLevel", this.ArmorPotionLevel);
            nbt.m_128379_("FearEffect", this.FearEffect);
            nbt.m_128379_("EnableSomnium", this.EnableSomnium);
            nbt.m_128379_("Prolog", this.Prolog);
            nbt.m_128347_("ManaCooldown", this.ManaCooldown);
            nbt.m_128347_("ManaDurability", this.ManaDurability);
            nbt.m_128347_("ManaDamage", this.ManaDamage);
            nbt.m_128359_("Playername", this.Playername);
            nbt.m_128347_("PlayerRep", this.PlayerRep);
            nbt.m_128347_("NightbladeY", this.NightbladeY);
            nbt.m_128347_("NightbladeX", this.NightbladeX);
            nbt.m_128347_("NightbladeZ", this.NightbladeZ);
            nbt.m_128347_("HomeY", this.HomeY);
            nbt.m_128347_("HomeZ", this.HomeZ);
            nbt.m_128347_("HomeX", this.HomeX);
            nbt.m_128379_("RingOfHome", this.RingOfHome);
            nbt.m_128347_("PocketPlayerZ", this.PocketPlayerZ);
            nbt.m_128347_("PocketPlayerY", this.PocketPlayerY);
            nbt.m_128347_("PocketPlayerX", this.PocketPlayerX);
            nbt.m_128379_("PocketDimension", this.PocketDimension);
            nbt.m_128347_("ClockX", this.ClockX);
            nbt.m_128347_("ClockY", this.ClockY);
            nbt.m_128347_("ClockZ", this.ClockZ);
            nbt.m_128379_("ClockActive", this.ClockActive);
            nbt.m_128379_("FoundBody", this.FoundBody);
            nbt.m_128379_("DestriyAfterLifeItem", this.DestriyAfterLifeItem);
            nbt.m_128379_("FireworkOnJoin", this.FireworkOnJoin);
            nbt.m_128379_("ParticlesOnDeath", this.ParticlesOnDeath);
            nbt.m_128379_("WalkParticles", this.WalkParticles);
            nbt.m_128379_("P3", this.P3);
            nbt.m_128379_("P4", this.P4);
            nbt.m_128379_("P5", this.P5);
            nbt.m_128379_("P6", this.P6);
            nbt.m_128347_("NetherX", this.NetherX);
            nbt.m_128347_("NetherY", this.NetherY);
            nbt.m_128347_("NetherZ", this.NetherZ);
            nbt.m_128347_("EndX", this.EndX);
            nbt.m_128347_("EndY", this.EndY);
            nbt.m_128347_("EndZ", this.EndZ);
            nbt.m_128347_("AbyssX", this.AbyssX);
            nbt.m_128347_("AbyssY", this.AbyssY);
            nbt.m_128347_("AbyssZ", this.AbyssZ);
            nbt.m_128347_("OverworldX", this.OverworldX);
            nbt.m_128347_("OverworldY", this.OverworldY);
            nbt.m_128347_("OverworldZ", this.OverworldZ);
            nbt.m_128379_("CrimsonCrystalResearch", this.CrimsonCrystalResearch);
            nbt.m_128379_("WarpedCrystalResearch", this.WarpedCrystalResearch);
            nbt.m_128379_("EnderCrystalResearch", this.EnderCrystalResearch);
            nbt.m_128379_("AbyssCrystalResearch", this.AbyssCrystalResearch);
            nbt.m_128379_("FrostCrystalResearch", this.FrostCrystalResearch);
            nbt.m_128379_("HollowCrystalResearch", this.HollowCrystalResearch);
            nbt.m_128379_("LPMMode", this.LPMMode);
            nbt.m_128379_("EnableManaBar", this.EnableManaBar);
            nbt.m_128379_("FirstJoin", this.FirstJoin);
            nbt.m_128379_("PX", this.PX);
            nbt.m_128347_("HudX", this.HudX);
            nbt.m_128347_("HudY", this.HudY);
            nbt.m_128379_("HasAbsorb", this.HasAbsorb);
            nbt.m_128379_("HasArmor", this.HasArmor);
            nbt.m_128379_("HasExtraHP", this.HasExtraHP);
            nbt.m_128379_("BarComp", this.BarComp);
            nbt.m_128379_("EmptySomnium", this.EmptySomnium);
            nbt.m_128379_("SomniumHandler", this.SomniumHandler);
            nbt.m_128379_("EternalAbyss", this.EternalAbyss);
            nbt.m_128379_("EA_Intro", this.EA_Intro);
            nbt.m_128379_("FriendMode", this.FriendMode);
            nbt.m_128347_("Infected", this.Infected);
            nbt.m_128347_("Freeze", this.Freeze);
            nbt.m_128379_("CavernaCrystalResearch", this.CavernaCrystalResearch);
            nbt.m_128379_("AurelCrystalResearch", this.AurelCrystalResearch);
            nbt.m_128379_("HolyPlayer", this.HolyPlayer);
            nbt.m_128379_("ConfigBook", this.ConfigBook);
            nbt.m_128359_("GetDimension", this.GetDimension);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.SaveFD = nbt.m_128459_("SaveFD");
            this.SaveY = nbt.m_128459_("SaveY");
            this.SaveZ = nbt.m_128459_("SaveZ");
            this.BookSpawn = nbt.m_128471_("BookSpawn");
            this.SaveX = nbt.m_128459_("SaveX");
            this.SaveHP = nbt.m_128459_("SaveHP");
            this.SleepEvent = nbt.m_128471_("SleepEvent");
            this.Mana = nbt.m_128459_("Mana");
            this.WandAbility = nbt.m_128461_("WandAbility");
            this.RadioEvent = nbt.m_128471_("RadioEvent");
            this.AbyssCloak = nbt.m_128471_("AbyssCloak");
            this.ManaBarToggle = nbt.m_128471_("ManaBarToggle");
            this.ManaBlinkAnimation = nbt.m_128471_("ManaBlinkAnimation");
            this.ManaUpgrade = nbt.m_128459_("ManaUpgrade");
            this.ManaRegenUpgrade = nbt.m_128459_("ManaRegenUpgrade");
            this.SleepEvent2 = nbt.m_128471_("SleepEvent2");
            this.GetConfigVersion = nbt.m_128461_("GetConfigVersion");
            this.ArmorPotionLevel = nbt.m_128459_("ArmorPotionLevel");
            this.FearEffect = nbt.m_128471_("FearEffect");
            this.EnableSomnium = nbt.m_128471_("EnableSomnium");
            this.Prolog = nbt.m_128471_("Prolog");
            this.ManaCooldown = nbt.m_128459_("ManaCooldown");
            this.ManaDurability = nbt.m_128459_("ManaDurability");
            this.ManaDamage = nbt.m_128459_("ManaDamage");
            this.Playername = nbt.m_128461_("Playername");
            this.PlayerRep = nbt.m_128459_("PlayerRep");
            this.NightbladeY = nbt.m_128459_("NightbladeY");
            this.NightbladeX = nbt.m_128459_("NightbladeX");
            this.NightbladeZ = nbt.m_128459_("NightbladeZ");
            this.HomeY = nbt.m_128459_("HomeY");
            this.HomeZ = nbt.m_128459_("HomeZ");
            this.HomeX = nbt.m_128459_("HomeX");
            this.RingOfHome = nbt.m_128471_("RingOfHome");
            this.PocketPlayerZ = nbt.m_128459_("PocketPlayerZ");
            this.PocketPlayerY = nbt.m_128459_("PocketPlayerY");
            this.PocketPlayerX = nbt.m_128459_("PocketPlayerX");
            this.PocketDimension = nbt.m_128471_("PocketDimension");
            this.ClockX = nbt.m_128459_("ClockX");
            this.ClockY = nbt.m_128459_("ClockY");
            this.ClockZ = nbt.m_128459_("ClockZ");
            this.ClockActive = nbt.m_128471_("ClockActive");
            this.FoundBody = nbt.m_128471_("FoundBody");
            this.DestriyAfterLifeItem = nbt.m_128471_("DestriyAfterLifeItem");
            this.FireworkOnJoin = nbt.m_128471_("FireworkOnJoin");
            this.ParticlesOnDeath = nbt.m_128471_("ParticlesOnDeath");
            this.WalkParticles = nbt.m_128471_("WalkParticles");
            this.P3 = nbt.m_128471_("P3");
            this.P4 = nbt.m_128471_("P4");
            this.P5 = nbt.m_128471_("P5");
            this.P6 = nbt.m_128471_("P6");
            this.NetherX = nbt.m_128459_("NetherX");
            this.NetherY = nbt.m_128459_("NetherY");
            this.NetherZ = nbt.m_128459_("NetherZ");
            this.EndX = nbt.m_128459_("EndX");
            this.EndY = nbt.m_128459_("EndY");
            this.EndZ = nbt.m_128459_("EndZ");
            this.AbyssX = nbt.m_128459_("AbyssX");
            this.AbyssY = nbt.m_128459_("AbyssY");
            this.AbyssZ = nbt.m_128459_("AbyssZ");
            this.OverworldX = nbt.m_128459_("OverworldX");
            this.OverworldY = nbt.m_128459_("OverworldY");
            this.OverworldZ = nbt.m_128459_("OverworldZ");
            this.CrimsonCrystalResearch = nbt.m_128471_("CrimsonCrystalResearch");
            this.WarpedCrystalResearch = nbt.m_128471_("WarpedCrystalResearch");
            this.EnderCrystalResearch = nbt.m_128471_("EnderCrystalResearch");
            this.AbyssCrystalResearch = nbt.m_128471_("AbyssCrystalResearch");
            this.FrostCrystalResearch = nbt.m_128471_("FrostCrystalResearch");
            this.HollowCrystalResearch = nbt.m_128471_("HollowCrystalResearch");
            this.LPMMode = nbt.m_128471_("LPMMode");
            this.EnableManaBar = nbt.m_128471_("EnableManaBar");
            this.FirstJoin = nbt.m_128471_("FirstJoin");
            this.PX = nbt.m_128471_("PX");
            this.HudX = nbt.m_128459_("HudX");
            this.HudY = nbt.m_128459_("HudY");
            this.HasAbsorb = nbt.m_128471_("HasAbsorb");
            this.HasArmor = nbt.m_128471_("HasArmor");
            this.HasExtraHP = nbt.m_128471_("HasExtraHP");
            this.BarComp = nbt.m_128471_("BarComp");
            this.EmptySomnium = nbt.m_128471_("EmptySomnium");
            this.SomniumHandler = nbt.m_128471_("SomniumHandler");
            this.EternalAbyss = nbt.m_128471_("EternalAbyss");
            this.EA_Intro = nbt.m_128471_("EA_Intro");
            this.FriendMode = nbt.m_128471_("FriendMode");
            this.Infected = nbt.m_128459_("Infected");
            this.Freeze = nbt.m_128459_("Freeze");
            this.CavernaCrystalResearch = nbt.m_128471_("CavernaCrystalResearch");
            this.AurelCrystalResearch = nbt.m_128471_("AurelCrystalResearch");
            this.HolyPlayer = nbt.m_128471_("HolyPlayer");
            this.ConfigBook = nbt.m_128471_("ConfigBook");
            this.GetDimension = nbt.m_128461_("GetDimension");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("theabyss", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "theabyss_mapvars";
        public double XTest = 0.0;
        public double ZTest = 0.0;
        public boolean FullSomnium = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.XTest = nbt.m_128459_("XTest");
            this.ZTest = nbt.m_128459_("ZTest");
            this.FullSomnium = nbt.m_128471_("FullSomnium");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("XTest", this.XTest);
            nbt.m_128347_("ZTest", this.ZTest);
            nbt.m_128379_("FullSomnium", this.FullSomnium);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "theabyss_worldvars";
        public double MobLevel = 0.0;
        public double PocketDimensionX = 0.0;
        public double PocketDimensionZ = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.MobLevel = nbt.m_128459_("MobLevel");
            this.PocketDimensionX = nbt.m_128459_("PocketDimensionX");
            this.PocketDimensionZ = nbt.m_128459_("PocketDimensionZ");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("MobLevel", this.MobLevel);
            nbt.m_128347_("PocketDimensionX", this.PocketDimensionX);
            nbt.m_128347_("PocketDimensionZ", this.PocketDimensionZ);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.SaveFD = original.SaveFD;
            clone.SaveY = original.SaveY;
            clone.SaveZ = original.SaveZ;
            clone.BookSpawn = original.BookSpawn;
            clone.SaveX = original.SaveX;
            clone.SaveHP = original.SaveHP;
            clone.SleepEvent = original.SleepEvent;
            clone.Mana = original.Mana;
            clone.WandAbility = original.WandAbility;
            clone.RadioEvent = original.RadioEvent;
            clone.AbyssCloak = original.AbyssCloak;
            clone.ManaBarToggle = original.ManaBarToggle;
            clone.ManaBlinkAnimation = original.ManaBlinkAnimation;
            clone.ManaUpgrade = original.ManaUpgrade;
            clone.ManaRegenUpgrade = original.ManaRegenUpgrade;
            clone.SleepEvent2 = original.SleepEvent2;
            clone.GetConfigVersion = original.GetConfigVersion;
            clone.ArmorPotionLevel = original.ArmorPotionLevel;
            clone.FearEffect = original.FearEffect;
            clone.EnableSomnium = original.EnableSomnium;
            clone.Prolog = original.Prolog;
            clone.ManaCooldown = original.ManaCooldown;
            clone.ManaDurability = original.ManaDurability;
            clone.ManaDamage = original.ManaDamage;
            clone.Playername = original.Playername;
            clone.PlayerRep = original.PlayerRep;
            clone.NightbladeY = original.NightbladeY;
            clone.NightbladeX = original.NightbladeX;
            clone.NightbladeZ = original.NightbladeZ;
            clone.HomeY = original.HomeY;
            clone.HomeZ = original.HomeZ;
            clone.HomeX = original.HomeX;
            clone.RingOfHome = original.RingOfHome;
            clone.PocketPlayerZ = original.PocketPlayerZ;
            clone.PocketPlayerY = original.PocketPlayerY;
            clone.PocketPlayerX = original.PocketPlayerX;
            clone.PocketDimension = original.PocketDimension;
            clone.ClockX = original.ClockX;
            clone.ClockY = original.ClockY;
            clone.ClockZ = original.ClockZ;
            clone.ClockActive = original.ClockActive;
            clone.FoundBody = original.FoundBody;
            clone.DestriyAfterLifeItem = original.DestriyAfterLifeItem;
            clone.FireworkOnJoin = original.FireworkOnJoin;
            clone.ParticlesOnDeath = original.ParticlesOnDeath;
            clone.WalkParticles = original.WalkParticles;
            clone.P3 = original.P3;
            clone.P4 = original.P4;
            clone.P5 = original.P5;
            clone.P6 = original.P6;
            clone.NetherX = original.NetherX;
            clone.NetherY = original.NetherY;
            clone.NetherZ = original.NetherZ;
            clone.EndX = original.EndX;
            clone.EndY = original.EndY;
            clone.EndZ = original.EndZ;
            clone.AbyssX = original.AbyssX;
            clone.AbyssY = original.AbyssY;
            clone.AbyssZ = original.AbyssZ;
            clone.OverworldX = original.OverworldX;
            clone.OverworldY = original.OverworldY;
            clone.OverworldZ = original.OverworldZ;
            clone.CrimsonCrystalResearch = original.CrimsonCrystalResearch;
            clone.WarpedCrystalResearch = original.WarpedCrystalResearch;
            clone.EnderCrystalResearch = original.EnderCrystalResearch;
            clone.AbyssCrystalResearch = original.AbyssCrystalResearch;
            clone.FrostCrystalResearch = original.FrostCrystalResearch;
            clone.HollowCrystalResearch = original.HollowCrystalResearch;
            clone.LPMMode = original.LPMMode;
            clone.EnableManaBar = original.EnableManaBar;
            clone.FirstJoin = original.FirstJoin;
            clone.PX = original.PX;
            clone.HudX = original.HudX;
            clone.HudY = original.HudY;
            clone.HasAbsorb = original.HasAbsorb;
            clone.HasArmor = original.HasArmor;
            clone.HasExtraHP = original.HasExtraHP;
            clone.BarComp = original.BarComp;
            clone.EmptySomnium = original.EmptySomnium;
            clone.SomniumHandler = original.SomniumHandler;
            clone.EternalAbyss = original.EternalAbyss;
            clone.EA_Intro = original.EA_Intro;
            clone.FriendMode = original.FriendMode;
            clone.Infected = original.Infected;
            clone.Freeze = original.Freeze;
            clone.CavernaCrystalResearch = original.CavernaCrystalResearch;
            clone.AurelCrystalResearch = original.AurelCrystalResearch;
            clone.HolyPlayer = original.HolyPlayer;
            clone.ConfigBook = original.ConfigBook;
            clone.GetDimension = original.GetDimension;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    TheabyssMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TheabyssMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                TheabyssMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

