/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.recipes;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.yezon.theabyss.TheabyssMod;
import oshi.util.tuples.Pair;

public final class RecipeDisplayData {
    private final ResourceLocation jeiPngName;
    private final int width;
    private final int height;
    private final Supplier<? extends ItemLike> tabIcon;
    private final RecipeTransferHolder<? extends AbstractContainerMenu> recipeTransferHolder;
    @Nullable
    private final AnimatedDrawableBuilder animatedDrawable;
    private final List<Pair<Integer, Integer>> ingredientMapping;
    private final int resultX;
    private final int resultY;
    @Nullable
    private RecipeViewHolder recipeViewArea;

    public RecipeDisplayData(ResourceLocation jeiPngName, int width, int height, Supplier<? extends ItemLike> tabIcon, @Nullable RecipeViewHolder recipeViewArea, RecipeTransferHolder<? extends AbstractContainerMenu> recipeTransferHolder, @Nullable AnimatedDrawableBuilder animatedDrawable, List<Pair<Integer, Integer>> ingredientMapping, int resultX, int resultY) {
        this.jeiPngName = jeiPngName;
        this.width = width;
        this.height = height;
        this.tabIcon = tabIcon;
        this.recipeViewArea = recipeViewArea;
        this.recipeTransferHolder = recipeTransferHolder;
        this.animatedDrawable = animatedDrawable;
        this.ingredientMapping = ingredientMapping;
        this.resultX = resultX;
        this.resultY = resultY;
    }

    public void setRecipeViewArea(@Nullable RecipeViewHolder recipeViewArea) {
        this.recipeViewArea = recipeViewArea;
    }

    public ResourceLocation jeiPngName() {
        return this.jeiPngName;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public Supplier<? extends ItemLike> tabIcon() {
        return this.tabIcon;
    }

    @Nullable
    public RecipeViewHolder recipeViewArea() {
        return this.recipeViewArea;
    }

    public RecipeTransferHolder<? extends AbstractContainerMenu> recipeTransferHolder() {
        return this.recipeTransferHolder;
    }

    @Nullable
    public AnimatedDrawableBuilder animatedDrawable() {
        return this.animatedDrawable;
    }

    public List<Pair<Integer, Integer>> ingredientMapping() {
        return this.ingredientMapping;
    }

    public int resultX() {
        return this.resultX;
    }

    public int resultY() {
        return this.resultY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RecipeDisplayData that = (RecipeDisplayData)obj;
        return Objects.equals(this.jeiPngName, that.jeiPngName) && this.width == that.width && this.height == that.height && Objects.equals(this.tabIcon, that.tabIcon) && Objects.equals(this.recipeViewArea, that.recipeViewArea) && Objects.equals(this.recipeTransferHolder, that.recipeTransferHolder) && Objects.equals(this.animatedDrawable, that.animatedDrawable) && Objects.equals(this.ingredientMapping, that.ingredientMapping) && this.resultX == that.resultX && this.resultY == that.resultY;
    }

    public int hashCode() {
        return Objects.hash(this.jeiPngName, this.width, this.height, this.tabIcon, this.recipeViewArea, this.recipeTransferHolder, this.animatedDrawable, this.ingredientMapping, this.resultX, this.resultY);
    }

    public String toString() {
        return "RecipeDisplayData[jeiPngName=" + this.jeiPngName + ", width=" + this.width + ", height=" + this.height + ", tabIcon=" + this.tabIcon + ", recipeViewArea=" + this.recipeViewArea + ", recipeTransferHolder=" + this.recipeTransferHolder + ", animatedDrawable=" + this.animatedDrawable + ", ingredientMapping=" + this.ingredientMapping + ", resultX=" + this.resultX + ", resultY=" + this.resultY + "]";
    }

    public record RecipeViewHolder(Class<? extends AbstractContainerScreen<?>> screenClass, int x, int y, int width, int height) {
        public static RecipeViewHolder of(Class<? extends AbstractContainerScreen<?>> screenClass, int x, int y) {
            return new RecipeViewHolder(screenClass, x, y, 20, 20);
        }
    }

    public record RecipeTransferHolder<T extends AbstractContainerMenu>(Class<T> menuClass, Supplier<? extends MenuType<T>> menuType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
    }

    public record AnimatedDrawableBuilder(int u, int v, int width, int height, int x, int y, int tickPerCycle, StartFrom from, boolean inverted) {

        public static enum StartFrom {
            TOP,
            BOTTOM,
            LEFT,
            RIGHT;

        }
    }

    public static class Builder {
        private final ResourceLocation imageLocation;
        private final int width;
        private final int height;
        private final Supplier<? extends ItemLike> tabIcon;
        private final List<Pair<Integer, Integer>> ingredientMapping;
        @Deprecated
        @Nullable
        private RecipeViewHolder recipeViewArea;
        @Nullable
        private RecipeTransferHolder<? extends AbstractContainerMenu> recipeTransferHolder;
        @Nullable
        private AnimatedDrawableBuilder animatedDrawable;

        public Builder(String imageName, int width, int height, Supplier<? extends ItemLike> tabIcon) {
            this.imageLocation = TheabyssMod.location("textures/jei/" + imageName + (imageName.contains(".png") ? "" : ".png"));
            this.width = width;
            this.height = height;
            this.tabIcon = tabIcon;
            this.ingredientMapping = new LinkedList<Pair<Integer, Integer>>();
        }

        public static Builder builder(String imageName, int width, int height, Supplier<? extends ItemLike> tabIcon) {
            return new Builder(imageName, width, height, tabIcon);
        }

        @Deprecated
        public Builder addRecipeViewArea(Class<? extends AbstractContainerScreen<?>> screenClass, int x, int y) {
            return this.addRecipeViewArea(screenClass, x, y, 20, 20);
        }

        @Deprecated
        public Builder addRecipeViewArea(Class<? extends AbstractContainerScreen<?>> screenClass, int x, int y, int width, int height) {
            this.recipeViewArea = new RecipeViewHolder(screenClass, x, y, width, height);
            return this;
        }

        public <T extends AbstractContainerMenu> Builder addRecipeTransferHandler(Class<T> menuClass, Supplier<? extends MenuType<T>> menuType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
            this.recipeTransferHolder = new RecipeTransferHolder<T>(menuClass, menuType, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
            return this;
        }

        public Builder addIngredient(int x, int y) {
            this.ingredientMapping.add((Pair<Integer, Integer>)new Pair((Object)x, (Object)y));
            return this;
        }

        public Builder addAnimatedDrawable(int u, int v, int width, int height, int x, int y, int tickPerCycle, AnimatedDrawableBuilder.StartFrom from, boolean inverted) {
            this.animatedDrawable = new AnimatedDrawableBuilder(u, v, width, height, x, y, tickPerCycle, from, inverted);
            return this;
        }

        public RecipeDisplayData construct(int resultSlotX, int resultSlotY) {
            if (this.recipeTransferHolder == null) {
                TheabyssMod.LOGGER.warn("Recipe transfer handler for [{}] is missing", (Object)this.imageLocation);
            }
            return new RecipeDisplayData(this.imageLocation, this.width, this.height, this.tabIcon, this.recipeViewArea, this.recipeTransferHolder, this.animatedDrawable, this.ingredientMapping, resultSlotX, resultSlotY);
        }
    }
}

