/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.recipes.impl;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.yezon.theabyss.recipes.AllRecipeTypes;
import net.yezon.theabyss.recipes.TheAbyssRecipe;

public class ArcaneStationRecipe
extends TheAbyssRecipe {
    private final Ingredient core;

    public ArcaneStationRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, Ingredient core, ItemStack result) {
        super(id, result, AllRecipeTypes.ARCANE_CRAFTING, ingredients);
        this.core = core;
        Preconditions.checkState((ingredients.size() == 9 ? 1 : 0) != 0);
        ingredients.set(ingredients.size() - 1, (Object)this.core);
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        for (int i = 0; i < 8; ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(pContainer.m_8020_(i))) continue;
            return false;
        }
        return this.core.test(pContainer.m_8020_(8));
    }

    @Override
    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return AllRecipeTypes.ARCANE_CRAFTING.getSerializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return AllRecipeTypes.ARCANE_CRAFTING.getVanillaType();
    }

    public Ingredient getCenterIngredient() {
        return this.core;
    }

    public static enum RecipeMode {
        FILL((jsonObject, list) -> {
            Preconditions.checkState((boolean)jsonObject.has("ingredient"), (Object)"Expected to find an 'ingredient', but not found");
            list.replaceAll(ignored -> Ingredient.m_43917_((JsonElement)jsonObject.getAsJsonObject("ingredient")));
        }, (ingredients, jsonObject) -> {
            Preconditions.checkState((ingredients.size() == 1 ? 1 : 0) != 0);
            jsonObject.add("ingredient", ((Ingredient)ingredients.get(0)).m_43942_());
        }),
        HALF((jsonObject, list) -> {
            Preconditions.checkState((jsonObject.has("first_half") && jsonObject.has("second_half") ? 1 : 0) != 0, (Object)"Expected to find 'first_half' and 'second_half', but either of or both is missing");
            for (int i = 0; i < 8; ++i) {
                list.set(i, (Object)Ingredient.m_43917_((JsonElement)jsonObject.getAsJsonObject(i < 4 ? "first_half" : "second_half")));
            }
        }, (ingredients, jsonObject) -> {
            Preconditions.checkState((ingredients.size() == 2 ? 1 : 0) != 0, (Object)("Ingredient list just need 2 members for 2 half of the circle, but found " + ingredients.size() + " member(s)"));
            jsonObject.add("first_half", ((Ingredient)ingredients.get(0)).m_43942_());
            jsonObject.add("second_half", ((Ingredient)ingredients.get(1)).m_43942_());
        }),
        TWO_INGREDIENTS((jsonObject, list) -> {
            Preconditions.checkState((jsonObject.has("first") && jsonObject.has("second") ? 1 : 0) != 0, (Object)"Expected to find the 'first' and 'second', but either or both of them is missing");
            block4: for (int i = 0; i < 8; ++i) {
                switch (i) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        list.set(i, (Object)Ingredient.m_43917_((JsonElement)jsonObject.getAsJsonObject("first")));
                        continue block4;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: {
                        list.set(i, (Object)Ingredient.m_43917_((JsonElement)jsonObject.getAsJsonObject("second")));
                    }
                }
            }
        }, (ingredients, jsonObject) -> {
            Preconditions.checkState((ingredients.size() == 2 ? 1 : 0) != 0, (Object)("Ingredient list just need 2 members for 2 half of the circle, but found " + ingredients.size() + " member(s)"));
            jsonObject.add("first", ((Ingredient)ingredients.get(0)).m_43942_());
            jsonObject.add("second", ((Ingredient)ingredients.get(1)).m_43942_());
        }),
        NONE((jsonObject, list) -> {}, (ingredients, jsonObject) -> {});

        private final BiConsumer<JsonObject, NonNullList<Ingredient>> reader;
        private final BiConsumer<List<Ingredient>, JsonObject> ingredientWriter;

        private RecipeMode(BiConsumer<JsonObject, NonNullList<Ingredient>> reader, BiConsumer<List<Ingredient>, JsonObject> ingredientWriter) {
            this.reader = reader;
            this.ingredientWriter = ingredientWriter;
        }

        public static NonNullList<Ingredient> readFromJson(JsonObject modeJson) {
            Preconditions.checkState((!modeJson.isJsonNull() ? 1 : 0) != 0, (Object)"JsonObject for recipe 'mode' is missing");
            Preconditions.checkState((boolean)modeJson.has("name"), (Object)"recipe mode needs a name, but it is missing");
            NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            RecipeMode recipeMode = RecipeMode.valueOf(GsonHelper.m_13906_((JsonObject)modeJson, (String)"name").toUpperCase(Locale.ROOT));
            recipeMode.reader.accept(modeJson, (NonNullList<Ingredient>)ingredients);
            return ingredients;
        }

        public void toJson(JsonObject jsonObject, List<Ingredient> ingredients) {
            JsonObject modeObject = new JsonObject();
            modeObject.addProperty("name", this.name());
            this.ingredientWriter.accept(ingredients, modeObject);
            jsonObject.add("mode", (JsonElement)modeObject);
        }
    }
}

