/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.utils;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.yezon.theabyss.recipes.AbyssRecipeType;
import net.yezon.theabyss.recipes.AllRecipeTypes;
import net.yezon.theabyss.recipes.impl.ArcaneStationRecipe;
import net.yezon.theabyss.recipes.impl.MortarAndPestleRecipe;
import net.yezon.theabyss.recipes.impl.SomniumInfusingRecipe;

public final class RecipeUtils {
    private RecipeUtils() {
    }

    @Nullable
    public static <T extends Container, R extends Recipe<T>> R getRecipeFor(@Nullable Level level, AbyssRecipeType recipeType, T container) {
        Preconditions.checkNotNull((Object)level);
        RecipeManager sidedRecipeManager = level.m_5776_() ? level.m_7465_() : ((ServerLevel)level).m_7654_().m_129894_();
        return (R)((Recipe)sidedRecipeManager.m_44015_(recipeType.getVanillaType(), container, level).orElse(null));
    }

    public static RecipeSerializer<ArcaneStationRecipe> createArcaneStationSerializer() {
        return new RecipeSerializer<ArcaneStationRecipe>(){

            public ArcaneStationRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
                ItemStack result = ShapedRecipe.m_151274_((JsonObject)pSerializedRecipe.getAsJsonObject("result"));
                Ingredient core = Ingredient.m_43917_((JsonElement)pSerializedRecipe.getAsJsonObject("core"));
                NonNullList<Ingredient> ingredients = ArcaneStationRecipe.RecipeMode.readFromJson(pSerializedRecipe.getAsJsonObject("mode"));
                return new ArcaneStationRecipe(pRecipeId, ingredients, core, result);
            }

            public ArcaneStationRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
                NonNullList<Ingredient> fromNetworkIngredients = RecipeUtils.ingredientsFromNetwork(pBuffer, 8, 9);
                return new ArcaneStationRecipe(pRecipeId, fromNetworkIngredients, Ingredient.m_43940_((FriendlyByteBuf)pBuffer), pBuffer.m_130267_());
            }

            public void toNetwork(FriendlyByteBuf pBuffer, ArcaneStationRecipe pRecipe) {
                RecipeUtils.ingredientsToNetwork(pBuffer, pRecipe.m_7527_());
                pBuffer.m_130055_(pRecipe.result);
            }
        };
    }

    public static NonNullList<Ingredient> ingredientsFromNetwork(FriendlyByteBuf buffer, int size) {
        return RecipeUtils.ingredientsFromNetwork(buffer, size, size);
    }

    public static NonNullList<Ingredient> ingredientsFromNetwork(FriendlyByteBuf buffer, int size, int returnSize) {
        NonNullList ingredients = NonNullList.m_122780_((int)returnSize, (Object)Ingredient.f_43901_);
        for (int i = 0; i < size; ++i) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ingredients.set(i, (Object)ingredient);
        }
        return ingredients;
    }

    public static void ingredientsToNetwork(FriendlyByteBuf buffer, NonNullList<Ingredient> ingredients) {
        for (Ingredient ingredient : ingredients) {
            ingredient.m_43923_(buffer);
        }
    }

    public static JsonObject itemStackToJson(ItemStack itemStack) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString());
        if (itemStack.m_41613_() > 1) {
            jsonObject.addProperty("count", (Number)itemStack.m_41613_());
        }
        return jsonObject;
    }

    public static ResourceLocation getItemId(ItemStack itemStack) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()));
    }

    public static NonNullList<Ingredient> ingredientsFromJson(JsonObject pJsonObject, int expectedSize) {
        JsonElement jsonElement = pJsonObject.get("ingredients");
        Preconditions.checkState((!jsonElement.isJsonNull() && jsonElement.isJsonArray() ? 1 : 0) != 0);
        JsonArray ingredientArray = jsonElement.getAsJsonArray();
        Preconditions.checkState((ingredientArray.size() == expectedSize ? 1 : 0) != 0);
        NonNullList ingredients = NonNullList.m_122780_((int)expectedSize, (Object)Ingredient.f_43901_);
        for (int i = 0; i < ingredientArray.size(); ++i) {
            ingredients.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredientArray.get(i)));
        }
        return ingredients;
    }

    public static RecipeSerializer<SomniumInfusingRecipe> createSomniumInfusingSerializer() {
        return new RecipeSerializer<SomniumInfusingRecipe>(){

            public SomniumInfusingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
                NonNullList ingredients = NonNullList.m_122780_((int)6, (Object)Ingredient.f_43901_);
                ingredients.set(0, (Object)SomniumInfusingRecipe.SOMNIUM_FUEL);
                ingredients.set(1, (Object)SomniumInfusingRecipe.LORAN_FUEL);
                NonNullList<Ingredient> ingredientList = RecipeUtils.ingredientsFromJson(pSerializedRecipe, 4);
                for (int i = 0; i < ingredientList.size(); ++i) {
                    ingredients.set(i + 2, (Object)((Ingredient)ingredientList.get(i)));
                }
                ItemStack result = ShapedRecipe.m_151274_((JsonObject)pSerializedRecipe.getAsJsonObject("result"));
                int processTime = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"process_time", (int)200);
                return new SomniumInfusingRecipe(pRecipeId, result, (NonNullList<Ingredient>)ingredients, processTime);
            }

            public SomniumInfusingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
                NonNullList<Ingredient> ingredient = RecipeUtils.ingredientsFromNetwork(buffer, 6);
                ItemStack result = buffer.m_130267_();
                int processTime = buffer.readInt();
                return new SomniumInfusingRecipe(recipeId, result, ingredient, processTime);
            }

            public void toNetwork(FriendlyByteBuf buffer, SomniumInfusingRecipe recipe) {
                RecipeUtils.ingredientsToNetwork(buffer, recipe.m_7527_());
                buffer.m_130055_(recipe.m_8043_());
                buffer.writeInt(recipe.getProcessDuration());
            }
        };
    }

    public static RecipeSerializer<MortarAndPestleRecipe> createMortarAndPestleRecipe() {
        return new RecipeSerializer<MortarAndPestleRecipe>(){

            public MortarAndPestleRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
                NonNullList<Ingredient> ingredients = RecipeUtils.ingredientsFromJson(pSerializedRecipe, 5);
                ItemStack result = ShapedRecipe.m_151274_((JsonObject)pSerializedRecipe.getAsJsonObject("result"));
                return new MortarAndPestleRecipe(pRecipeId, result, ingredients);
            }

            public MortarAndPestleRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
                return new MortarAndPestleRecipe(pRecipeId, pBuffer.m_130267_(), RecipeUtils.ingredientsFromNetwork(pBuffer, 5));
            }

            public void toNetwork(FriendlyByteBuf pBuffer, MortarAndPestleRecipe pRecipe) {
                pBuffer.m_130055_(pRecipe.result);
                RecipeUtils.ingredientsToNetwork(pBuffer, pRecipe.m_7527_());
            }
        };
    }

    public static boolean isModRecipe(RecipeType<?> type) {
        for (AbyssRecipeType recipeType : AllRecipeTypes.ALL_RECIPE_TYPES) {
            if (!recipeType.getVanillaType().equals(type)) continue;
            return true;
        }
        return false;
    }
}

