/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.world.inventory;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.yezon.theabyss.init.TheabyssModBlocks;
import net.yezon.theabyss.init.TheabyssModMenus;
import net.yezon.theabyss.recipes.AllRecipeTypes;
import net.yezon.theabyss.recipes.impl.ArcaneStationRecipe;
import net.yezon.theabyss.utils.RecipeUtils;
import net.yezon.theabyss.world.inventory.TheAbyssContainerMenu;

public class ArcaneMenu
extends AbstractContainerMenu {
    public static final int CONTAINER_SIZE = 9;
    private static final int RESULT_SLOT_INDEX = 9;
    private final SimpleContainer craftingContainer;
    private final SimpleContainer resultSlot;
    private final ContainerLevelAccess access;
    private final Player player;

    public ArcaneMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public ArcaneMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess access) {
        super((MenuType)TheabyssModMenus.ARCANE.get(), pContainerId);
        int si;
        this.access = access;
        this.craftingContainer = new SimpleContainer(9){

            public void m_6596_() {
                ArcaneMenu.this.m_6199_((Container)this);
            }
        };
        this.resultSlot = new SimpleContainer(1){

            public void m_6596_() {
            }
        };
        this.player = pPlayerInventory.f_35978_;
        this.addCustomSlot(0, 44, 7);
        this.addCustomSlot(1, 71, 16);
        this.addCustomSlot(2, 80, 43);
        this.addCustomSlot(3, 71, 70);
        this.addCustomSlot(4, 44, 79);
        this.addCustomSlot(5, 17, 70);
        this.addCustomSlot(6, 8, 43);
        this.addCustomSlot(7, 17, 16);
        this.addCustomSlot(8, 44, 43);
        super.m_38897_(new Slot((Container)this.resultSlot, 0, 152, 43){

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                this.resultTaken();
                super.m_6654_();
            }

            protected void m_7169_(ItemStack pStack, int pAmount) {
            }

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }

            private void resultTaken() {
                TheAbyssContainerMenu.onResultSlotTaken((Container)ArcaneMenu.this.craftingContainer);
            }
        });
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)pPlayerInventory, sj + (si + 1) * 9, 8 + sj * 18, 112 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)pPlayerInventory, si, 8 + si * 18, 170));
        }
    }

    private void addCustomSlot(int index, int x, int y) {
        super.m_38897_(new Slot((Container)this.craftingContainer, index, x, y));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 10) {
                if (!this.m_38903_(itemstack1, 10, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (!this.m_38903_(itemstack1, 0, 10, false)) {
                if (index < 37 ? !this.m_38903_(itemstack1, 37, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 10, 37, false)) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return ArcaneMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)TheabyssModBlocks.ARCANE_WORKBENCH.get()));
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(pPlayer, (Container)this.craftingContainer));
    }

    public void m_6199_(Container pContainer) {
        this.access.m_39292_((level, pos) -> this.updateGrid((Level)level, this.player));
    }

    private void updateGrid(Level level, Player player) {
        if (!level.m_5776_()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = ItemStack.f_41583_;
            ArcaneStationRecipe recipe = (ArcaneStationRecipe)RecipeUtils.getRecipeFor(level, AllRecipeTypes.ARCANE_CRAFTING, this.craftingContainer);
            if (recipe != null) {
                itemStack = recipe.m_5874_((Container)this.craftingContainer);
            }
            this.resultSlot.m_6836_(0, itemStack);
            super.m_150404_(9, itemStack);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, super.m_182425_(), 9, itemStack));
        }
    }
}

