/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.recipe;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.networking.PacketHelper;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodecRecipeSerializer<R extends Recipe<?>>
implements RecipeSerializer<R> {
    private final RecipeType<R> recipeType;
    private final Function<ResourceLocation, Codec<R>> jsonCodec;
    private final Function<ResourceLocation, Codec<R>> networkCodec;

    public CodecRecipeSerializer(RecipeType<R> recipeType, Function<ResourceLocation, Codec<R>> codec) {
        this(recipeType, codec, codec);
    }

    public CodecRecipeSerializer(RecipeType<R> recipeType, Function<ResourceLocation, Codec<R>> jsonCodec, Function<ResourceLocation, Codec<R>> networkCodec) {
        this.recipeType = recipeType;
        this.jsonCodec = jsonCodec;
        this.networkCodec = networkCodec;
    }

    @NotNull
    public R m_6729_(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        return (R)((Recipe)this.jsonCodec.apply(id).parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, s -> Constants.LOGGER.error("Could not parse {}", (Object)id)));
    }

    @Nullable
    public R m_8005_(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
        return (R)((Recipe)PacketHelper.readWithYabn(buffer, this.networkCodec.apply(id), true).getOrThrow(false, s -> Constants.LOGGER.error("Could not parse {}", (Object)id)));
    }

    public void m_6178_(@NotNull FriendlyByteBuf buffer, @NotNull R recipe) {
        PacketHelper.writeWithYabn(buffer, this.networkCodec.apply(recipe.m_6423_()), recipe, true).getOrThrow(false, s -> Constants.LOGGER.error("Could not parse {}", (Object)recipe.m_6423_()));
    }

    public RecipeType<R> type() {
        return this.recipeType;
    }
}

