/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.scouter.netherdepthsupgrade.blocks.GrowingLavaPlantBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public abstract class GrowingLavaPlantHeadBlock
extends GrowingLavaPlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61411_;
    public static final int MAX_AGE = 25;
    private final double growPerTickProbability;

    protected GrowingLavaPlantHeadBlock(BlockBehaviour.Properties pProperties, Direction pGrowthDirection, VoxelShape pShape, boolean pScheduleFluidTicks, double pGrowPerTickProbability) {
        super(pProperties, pGrowthDirection, pShape, pScheduleFluidTicks);
        this.growPerTickProbability = pGrowPerTickProbability;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState getStateForPlacement(LevelAccessor pLevel) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(pLevel.m_213780_().m_188503_(25)));
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE) < 25;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos;
        if ((Integer)pState.m_61143_((Property)AGE) < 25 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos.m_121945_(this.growthDirection), (BlockState)pLevel.m_8055_(pPos.m_121945_(this.growthDirection)), (pRandom.m_188500_() < this.growPerTickProbability ? 1 : 0) != 0) && this.canGrowInto(pLevel.m_8055_(blockpos = pPos.m_121945_(this.growthDirection)))) {
            pLevel.m_46597_(blockpos, this.getGrowIntoState(pState, pLevel.f_46441_));
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)blockpos, (BlockState)pLevel.m_8055_(blockpos));
        }
    }

    protected BlockState getGrowIntoState(BlockState pState, RandomSource pRandom) {
        return (BlockState)pState.m_61122_((Property)AGE);
    }

    public BlockState getMaxAgeState(BlockState pState) {
        return (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(25));
    }

    public boolean isMaxAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE) == 25;
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState p_153329_, BlockState p_153330_) {
        return p_153330_;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == this.growthDirection.m_122424_() && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        if (pFacing != this.growthDirection || !pFacingState.m_60713_((Block)this) && !pFacingState.m_60713_(this.getBodyBlock())) {
            if (this.scheduleFluidTicks) {
                pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76195_, Fluids.f_76195_.m_6718_((LevelReader)pLevel));
            }
            return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return this.updateBodyAfterConvertedFromHead(pState, this.getBodyBlock().m_49966_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return this.canGrowInto(pLevel.m_8055_(pPos.m_121945_(this.growthDirection)));
    }

    public boolean m_214167_(Level pLevel, RandomSource pRand, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRand, BlockPos pPos, BlockState pState) {
        BlockPos blockpos = pPos.m_121945_(this.growthDirection);
        int i = Math.min((Integer)pState.m_61143_((Property)AGE) + 1, 25);
        int j = this.getBlocksToGrowWhenBonemealed(pRand);
        for (int k = 0; k < j && this.canGrowInto(pLevel.m_8055_(blockpos)); ++k) {
            pLevel.m_46597_(blockpos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)));
            blockpos = blockpos.m_121945_(this.growthDirection);
            i = Math.min(i + 1, 25);
        }
    }

    protected abstract int getBlocksToGrowWhenBonemealed(RandomSource var1);

    protected abstract boolean canGrowInto(BlockState var1);

    @Override
    protected GrowingLavaPlantHeadBlock getHeadBlock() {
        return this;
    }
}

