/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.datagen;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class BlockstateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public BlockstateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "netherdepthsupgrade", exFileHelper);
    }

    private String blockName(Block block) {
        return block.m_60589_().m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("netherdepthsupgrade", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)NDUBlocks.LAVA_SPONGE.get());
        this.simpleBlock((Block)NDUBlocks.WET_LAVA_SPONGE.get());
        this.simpleBlock((Block)NDUBlocks.LAVA_GLASS.get());
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public void tomatoBlock(Block block, ResourceLocation texture, String renderType) {
        this.tomatoBlock(block, this.key(block).toString(), texture, renderType);
    }

    public void tomatoBlock(Block block, String baseName, ResourceLocation texture, String renderType) {
        ModelBuilder age1 = ((BlockModelBuilder)this.models().cross(baseName + "_stage0", new ResourceLocation(texture.toString() + "_stage0"))).renderType(renderType);
        ModelBuilder age2 = ((BlockModelBuilder)this.models().cross(baseName + "_stage1", new ResourceLocation(texture.toString() + "_stage1"))).renderType(renderType);
        ModelBuilder age3 = ((BlockModelBuilder)this.models().cross(baseName + "_stage2", new ResourceLocation(texture.toString() + "_stage2"))).renderType(renderType);
        ModelBuilder age4 = ((BlockModelBuilder)this.models().cross(baseName + "_stage3", new ResourceLocation(texture.toString() + "_stage3"))).renderType(renderType);
        this.tomatoBlock(block, (ModelFile)age1, (ModelFile)age2, (ModelFile)age3, (ModelFile)age4);
    }

    private void tomatoBlock(Block block, ModelFile age1, ModelFile age2, ModelFile age3, ModelFile age4) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            switch ((Integer)state.m_61143_((Property)BlockStateProperties.f_61407_)) {
                default: {
                    return ConfiguredModel.builder().modelFile(age1).build();
                }
                case 1: {
                    return ConfiguredModel.builder().modelFile(age2).build();
                }
                case 2: {
                    return ConfiguredModel.builder().modelFile(age3).build();
                }
                case 3: 
            }
            return ConfiguredModel.builder().modelFile(age4).build();
        }, new Property[0]);
    }

    public String m_6055_() {
        return "Block States: netherdepthsupgrade";
    }
}

