/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import com.scouter.netherdepthsupgrade.entity.NDUMobType;
import com.scouter.netherdepthsupgrade.items.NDUItems;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LavaPufferfishEntity
extends AbstractLavaFish {
    private static final EntityDataAccessor<Integer> PUFF_STATE = SynchedEntityData.m_135353_(LavaPufferfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int inflateCounter;
    int deflateTimer;
    private static final Predicate<LivingEntity> SCARY_MOB = p_29634_ -> {
        if (p_29634_ instanceof Player && ((Player)p_29634_).m_7500_()) {
            return false;
        }
        return p_29634_.m_6095_() == EntityType.f_147039_ || p_29634_.m_6336_() != NDUMobType.LAVA;
    };
    static final TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(SCARY_MOB);
    public static final int STATE_SMALL = 0;
    public static final int STATE_MID = 1;
    public static final int STATE_FULL = 2;

    public LavaPufferfishEntity(EntityType<? extends LavaPufferfishEntity> p_29602_, Level p_29603_) {
        super((EntityType<? extends AbstractLavaFish>)p_29602_, p_29603_);
        this.m_6210_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PUFF_STATE, (Object)0);
    }

    public int getPuffState() {
        return (Integer)this.f_19804_.m_135370_(PUFF_STATE);
    }

    public void setPuffState(int p_29619_) {
        this.f_19804_.m_135381_(PUFF_STATE, (Object)p_29619_);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (PUFF_STATE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("PuffState", this.getPuffState());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setPuffState(Math.min(pCompound.m_128451_("PuffState"), 2));
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)NDUItems.LAVA_PUFFERFISH_BUCKET.get());
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PufferfishPuffGoal(this));
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            if (this.inflateCounter > 0) {
                if (this.getPuffState() == 0) {
                    this.m_5496_(SoundEvents.f_12291_, this.m_6121_(), this.m_6100_());
                    this.setPuffState(1);
                } else if (this.inflateCounter > 40 && this.getPuffState() == 1) {
                    this.m_5496_(SoundEvents.f_12291_, this.m_6121_(), this.m_6100_());
                    this.setPuffState(2);
                }
                ++this.inflateCounter;
            } else if (this.getPuffState() != 0) {
                if (this.deflateTimer > 60 && this.getPuffState() == 2) {
                    this.m_5496_(SoundEvents.f_12290_, this.m_6121_(), this.m_6100_());
                    this.setPuffState(1);
                } else if (this.deflateTimer > 100 && this.getPuffState() == 1) {
                    this.m_5496_(SoundEvents.f_12290_, this.m_6121_(), this.m_6100_());
                    this.setPuffState(0);
                }
                ++this.deflateTimer;
            }
        }
        super.m_8119_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.getPuffState() > 0) {
            for (Mob mob : this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(0.3), p_149013_ -> targetingConditions.m_26885_((LivingEntity)this, (LivingEntity)p_149013_))) {
                if (!mob.m_6084_()) continue;
                this.touch(mob);
            }
        }
    }

    private void touch(Mob p_29606_) {
        int i = this.getPuffState();
        if (p_29606_.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(1 + i))) {
            p_29606_.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 60 * i, 0), (Entity)this);
            this.m_5496_(SoundEvents.f_12295_, 1.0f, 1.0f);
        }
    }

    public void m_6123_(Player pEntity) {
        int i = this.getPuffState();
        if (pEntity instanceof ServerPlayer && i > 0 && pEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(1 + i))) {
            if (!this.m_20067_()) {
                ((ServerPlayer)pEntity).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132162_, 0.0f));
            }
            pEntity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 60 * i, 0), (Entity)this);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12289_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12292_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12294_;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12293_;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return super.m_6972_(pPose).m_20388_(LavaPufferfishEntity.getScale(this.getPuffState()));
    }

    private static float getScale(int p_29639_) {
        switch (p_29639_) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    static class PufferfishPuffGoal
    extends Goal {
        private final LavaPufferfishEntity fish;

        public PufferfishPuffGoal(LavaPufferfishEntity p_29642_) {
            this.fish = p_29642_;
        }

        public boolean m_8036_() {
            List list = this.fish.f_19853_.m_6443_(LivingEntity.class, this.fish.m_20191_().m_82400_(2.0), p_149015_ -> targetingConditions.m_26885_((LivingEntity)this.fish, p_149015_));
            return !list.isEmpty();
        }

        public void m_8056_() {
            this.fish.inflateCounter = 1;
            this.fish.deflateTimer = 0;
        }

        public void m_8041_() {
            this.fish.inflateCounter = 0;
        }
    }
}

