/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import com.scouter.netherdepthsupgrade.entity.ai.FishSwimGoal;
import com.scouter.netherdepthsupgrade.items.NDUItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SoulSuckerEntity
extends AbstractLavaFish
implements IAnimatable,
IAnimationTickable {
    private static final EntityDataAccessor<BlockPos> SOULSAND_POS = SynchedEntityData.m_135353_(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> SEEK_SOULSAND_TIMER = SynchedEntityData.m_135353_(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COOLDOWN_TTIMER = SynchedEntityData.m_135353_(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final Logger LOGGER = LogUtils.getLogger();
    public int suckTimer = 0;
    @Nullable
    protected FishSwimGoal fishSwimGoal;

    public SoulSuckerEntity(EntityType<? extends AbstractLavaFish> p_27523_, Level p_27524_) {
        super(p_27523_, p_27524_);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.fishSwimGoal = new FishSwimGoal(this);
        this.f_21345_.m_25352_(1, (Goal)new FindSoulSandGoal3(this));
        this.f_21345_.m_25352_(4, (Goal)this.fishSwimGoal);
        this.fishSwimGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.getCooldownTimer() > 0) {
            this.setSeekSoulSandTimer(this.getSeekSoulSandTimer() - 1);
            this.setCooldownTimer(this.getSeekSoulSandTimer());
        }
        ++this.suckTimer;
        BlockPos blockPos = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (this.f_19853_.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_50135_) || this.f_19853_.m_8055_(blockPos).m_60713_(Blocks.f_50135_) && this.m_20077_()) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20208_(0.6), this.m_20186_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)NDUItems.SOULSUCKER_BUCKET.get());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12325_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12404_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12397_;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12398_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("soulsucker.moving", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SOULSAND_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(SEEK_SOULSAND_TIMER, (Object)0);
        this.f_19804_.m_135372_(COOLDOWN_TTIMER, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SoulSandPosX", this.getSoulSandPos().m_123341_());
        pCompound.m_128405_("SoulSandPosY", this.getSoulSandPos().m_123342_());
        pCompound.m_128405_("SoulSandPosZ", this.getSoulSandPos().m_123343_());
        pCompound.m_128405_("seeksoulsandtimer", this.getSeekSoulSandTimer().intValue());
        pCompound.m_128405_("cooldowntimer", this.getCooldownTimer().intValue());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        int i = pCompound.m_128451_("SoulSandPosX");
        int j = pCompound.m_128451_("SoulSandPosY");
        int k = pCompound.m_128451_("SoulSandPosZ");
        this.setSoulsandPos(new BlockPos(i, j, k));
        this.setSeekSoulSandTimer(pCompound.m_128451_("seeksoulsandtimer"));
        this.setCooldownTimer(pCompound.m_128451_("cooldowntimer"));
        super.m_7378_(pCompound);
    }

    public void setSoulsandPos(BlockPos pPos) {
        this.f_19804_.m_135381_(SOULSAND_POS, (Object)pPos);
    }

    public BlockPos getSoulSandPos() {
        return (BlockPos)this.f_19804_.m_135370_(SOULSAND_POS);
    }

    public void setSeekSoulSandTimer(Integer time) {
        this.f_19804_.m_135381_(SEEK_SOULSAND_TIMER, (Object)time);
    }

    public Integer getSeekSoulSandTimer() {
        return (Integer)this.f_19804_.m_135370_(SEEK_SOULSAND_TIMER);
    }

    public void setCooldownTimer(Integer time) {
        this.f_19804_.m_135381_(COOLDOWN_TTIMER, (Object)time);
    }

    public Integer getCooldownTimer() {
        return (Integer)this.f_19804_.m_135370_(COOLDOWN_TTIMER);
    }

    protected boolean closeToNextPos() {
        BlockPos blockpos = this.m_21573_().m_26567_();
        return blockpos != null ? blockpos.m_203195_((Position)this.m_20182_(), 0.0) : false;
    }

    public static boolean checkDistance(BlockPos entityPos, BlockPos blockPos) {
        double z2;
        double z1;
        double z12;
        double y2;
        double y1;
        double y12;
        double x2;
        double x1 = entityPos.m_123341_();
        double x12 = x1 - (x2 = (double)blockPos.m_123341_());
        double disTot = x12 * x12 + (y12 = (y1 = (double)entityPos.m_123342_()) - (y2 = (double)blockPos.m_123342_())) * y12 + (z12 = (z1 = (double)entityPos.m_123343_()) - (z2 = (double)entityPos.m_123343_())) * z12;
        return disTot <= 3.0;
    }

    static class FindSoulSandGoal3
    extends Goal {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final SoulSuckerEntity mob;
        private int i = 0;
        private int counter = 0;
        private int suckCounter = 30;
        private BlockPos lastPos;
        private RandomSource rand = RandomSource.m_216327_();
        public final List<BlockPos> soulSandList = new ArrayList<BlockPos>();
        private boolean stuck;

        public FindSoulSandGoal3(SoulSuckerEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_20077_() && !this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7495_()).m_60713_(Blocks.f_50135_) && this.mob.getSeekSoulSandTimer() == 0;
        }

        public boolean m_8045_() {
            BlockPos blockpos = this.mob.getSoulSandPos();
            return this.mob.getSeekSoulSandTimer() == 0;
        }

        public void m_8056_() {
            if (this.mob.f_19853_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)this.mob.f_19853_;
                this.mob.m_21573_().m_26573_();
                BlockPos blockpos = this.mob.m_20183_();
                for (int x = -5; x < 5; ++x) {
                    for (int y = 0; y < 10; ++y) {
                        for (int z = -5; z < 5; ++z) {
                            double posZ;
                            double posY;
                            double posX = this.mob.m_20183_().m_123341_();
                            BlockPos blockPos = new BlockPos(posX - (double)x, (posY = (double)this.mob.m_20183_().m_123342_()) - (double)y, (posZ = (double)this.mob.m_20183_().m_123343_()) - (double)z);
                            if (!this.mob.f_19853_.m_8055_(blockPos).m_60713_(Blocks.f_50135_) || !this.mob.f_19853_.m_6425_(blockPos.m_7494_()).m_192917_((Fluid)Fluids.f_76195_) || this.mob.f_19853_.m_6425_(blockPos.m_7495_()).m_192917_((Fluid)Fluids.f_76195_) || !this.mob.f_19853_.m_8055_(blockPos.m_122012_()).m_60713_(Blocks.f_50135_) || !this.mob.f_19853_.m_8055_(blockPos.m_122029_()).m_60713_(Blocks.f_50135_) || !this.mob.f_19853_.m_8055_(blockPos.m_122019_()).m_60713_(Blocks.f_50135_) || !this.mob.f_19853_.m_8055_(blockPos.m_122024_()).m_60713_(Blocks.f_50135_)) continue;
                            this.soulSandList.add(blockPos);
                        }
                    }
                }
                if (this.soulSandList.size() > 0) {
                    this.mob.m_21573_().m_26519_((double)this.soulSandList.get(this.i).m_123341_(), (double)this.soulSandList.get(this.i).m_123342_() + 0.5, (double)this.soulSandList.get(this.i).m_123343_(), 1.0);
                } else {
                    this.mob.setSeekSoulSandTimer(500);
                    this.mob.setCooldownTimer(this.mob.getSeekSoulSandTimer());
                    this.mob.fishSwimGoal.m_25751_();
                    this.m_8041_();
                }
            }
        }

        public void m_8041_() {
            BlockPos blockpos = this.mob.getSoulSandPos();
            super.m_8041_();
            this.mob.setSeekSoulSandTimer(500);
            this.mob.setCooldownTimer(this.mob.getSeekSoulSandTimer());
            this.mob.fishSwimGoal.m_25751_();
            this.soulSandList.clear();
            this.suckCounter = 0;
            this.counter = 0;
            this.i = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            this.lastPos = this.mob.m_20183_();
            if (this.soulSandList.size() == 0 || this.i >= this.soulSandList.size()) {
                this.m_8041_();
                this.mob.fishSwimGoal.m_25751_();
                return;
            }
            if (!this.mob.f_19853_.m_8055_(this.soulSandList.get(this.i)).m_60713_(Blocks.f_50135_) && this.counter < this.soulSandList.size()) {
                ++this.i;
                ++this.counter;
            }
            if (this.soulSandList.size() == 0 || this.i >= this.soulSandList.size()) {
                this.m_8041_();
                this.mob.fishSwimGoal.m_25751_();
                return;
            }
            if ((this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7495_()).m_60713_(Blocks.f_50135_) || this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7495_()).m_60713_(Blocks.f_50136_)) && SoulSuckerEntity.checkDistance(this.mob.m_20183_(), this.soulSandList.get(this.i))) {
                ++this.suckCounter;
                this.mob.m_21573_().m_26519_((double)this.soulSandList.get(this.i).m_123341_(), (double)this.soulSandList.get(this.i).m_123342_() + 0.5, (double)this.soulSandList.get(this.i).m_123343_(), 1.0);
                if (this.suckCounter == 100) {
                    if (!this.mob.f_19853_.m_8055_(this.mob.m_20183_()).m_60713_(Blocks.f_50135_)) {
                        this.mob.f_19853_.m_7731_(this.mob.m_20183_().m_7495_(), Blocks.f_50136_.m_49966_(), 3);
                    } else {
                        this.mob.f_19853_.m_7731_(this.mob.m_20183_(), Blocks.f_50136_.m_49966_(), 3);
                    }
                    this.mob.f_19802_ = 30;
                    ++this.i;
                    ++this.counter;
                }
            } else {
                this.mob.m_21573_().m_26519_((double)this.soulSandList.get(this.i).m_123341_(), (double)(this.soulSandList.get(this.i).m_123342_() + 1), (double)this.soulSandList.get(this.i).m_123343_(), 1.0);
            }
            if (this.suckCounter >= 100) {
                if (this.counter < this.soulSandList.size()) {
                    this.mob.m_21573_().m_26519_((double)this.soulSandList.get(this.i).m_123341_(), (double)this.soulSandList.get(this.i).m_123342_() + 0.5, (double)this.soulSandList.get(this.i).m_123343_(), 1.0);
                } else {
                    BlockPos blockPos = new BlockPos(this.mob.m_20183_().m_123341_() + this.rand.m_216339_(-5, 5), this.mob.m_20183_().m_123342_() + this.rand.m_216339_(0, 3), this.mob.m_20183_().m_123343_() + this.rand.m_216339_(-5, 5));
                    if (this.mob.f_19853_.m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76195_)) {
                        this.mob.m_21573_().m_26519_((double)(this.mob.m_20183_().m_123341_() + this.rand.m_216339_(-5, 5)), (double)(this.mob.m_20183_().m_123342_() + this.rand.m_216339_(0, 3)), (double)(this.mob.m_20183_().m_123343_() + this.rand.m_216339_(-5, 5)), 1.0);
                    }
                    this.mob.setSeekSoulSandTimer(500);
                    this.m_8041_();
                }
                this.suckCounter = 0;
            }
        }
    }

    static class FindSoulSandGoal
    extends Goal {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final SoulSuckerEntity mob;
        private boolean stuck;

        public FindSoulSandGoal(SoulSuckerEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_20077_() && !this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7495_()).m_60713_(Blocks.f_50135_) && this.mob.getSeekSoulSandTimer() == 0;
        }

        public boolean m_8045_() {
            BlockPos blockpos = this.mob.getSoulSandPos();
            return !new BlockPos((double)blockpos.m_123341_(), this.mob.m_20186_(), (double)blockpos.m_123343_()).m_203195_((Position)this.mob.m_20182_(), 0.0) && !this.stuck || this.mob.getSeekSoulSandTimer() < 300;
        }

        public void m_8056_() {
            if (this.mob.f_19853_ instanceof ServerLevel) {
                this.mob.setSeekSoulSandTimer(this.mob.getSeekSoulSandTimer() + 1);
                ServerLevel serverlevel = (ServerLevel)this.mob.f_19853_;
                this.stuck = false;
                this.mob.m_21573_().m_26573_();
                BlockPos blockpos = this.mob.m_20183_();
                for (BlockPos blockpos1 : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.mob.m_20185_() - 2.0)), (int)Mth.m_14107_((double)(this.mob.m_20186_() - 10.0)), (int)Mth.m_14107_((double)(this.mob.m_20189_() - 2.0)), (int)Mth.m_14107_((double)(this.mob.m_20185_() + 2.0)), (int)(this.mob.m_146904_() + 2), (int)Mth.m_14107_((double)(this.mob.m_20189_() + 2.0)))) {
                    if (this.mob.f_19853_.m_8055_(blockpos1).m_60713_(Blocks.f_50135_) && this.mob.f_19853_.m_6425_(blockpos1.m_7494_()).m_192917_((Fluid)Fluids.f_76195_) && !this.mob.f_19853_.m_6425_(blockpos1.m_7495_()).m_192917_((Fluid)Fluids.f_76195_)) {
                        this.mob.setSoulsandPos(blockpos1);
                        blockpos = blockpos1;
                        break;
                    }
                    this.mob.setSeekSoulSandTimer(300);
                    this.mob.setCooldownTimer(this.mob.getSeekSoulSandTimer());
                    this.mob.fishSwimGoal.m_25751_();
                }
            }
        }

        public void m_8041_() {
            BlockPos blockpos = this.mob.getSoulSandPos();
            if (new BlockPos((double)blockpos.m_123341_(), this.mob.m_20186_(), (double)blockpos.m_123343_()).m_203195_((Position)this.mob.m_20182_(), 0.0) || this.stuck || this.mob.getSeekSoulSandTimer() >= 300) {
                super.m_8041_();
                this.mob.setSeekSoulSandTimer(300);
                this.mob.setCooldownTimer(this.mob.getSeekSoulSandTimer());
                this.mob.fishSwimGoal.m_25751_();
            }
        }

        public void m_8037_() {
            this.mob.setSeekSoulSandTimer(this.mob.getSeekSoulSandTimer() + 1);
            Level level = this.mob.f_19853_;
            if (this.mob.closeToNextPos() || this.mob.m_21573_().m_26571_()) {
                BlockPos blockpos;
                Vec3 vec3 = Vec3.m_82512_((Vec3i)this.mob.getSoulSandPos());
                LOGGER.info("vec3" + vec3);
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.mob, (int)16, (int)0, (Vec3)vec3, (double)0.3926991f);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.mob, (int)8, (int)0, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 != null && !level.m_6425_(blockpos = new BlockPos(vec31)).m_205070_(FluidTags.f_13132_)) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.mob, (int)8, (int)0, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.mob.m_21563_().m_24950_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (float)(this.mob.m_8085_() + 20), (float)this.mob.m_8132_());
                this.mob.m_21573_().m_26519_(vec3.f_82479_ - 1.0, vec3.f_82480_ - 1.0, vec3.f_82481_ - 1.0, 0.3);
                if (level.f_46441_.m_188503_(this.m_183277_(80)) == 0) {
                    level.m_7605_((Entity)this.mob, (byte)38);
                    this.mob.fishSwimGoal.m_25751_();
                }
            }
        }
    }
}

