/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client.fullscreen;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import de.nekeras.borderless.client.GlfwUtils;
import de.nekeras.borderless.client.GlfwWindowAttribute;
import de.nekeras.borderless.client.fullscreen.FullscreenDisplayMode;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class BorderlessFullscreenDisplay
implements FullscreenDisplayMode {
    private static final Logger log = LogManager.getLogger();

    @Override
    public void apply(@Nonnull Window window) {
        FullscreenDisplayMode.super.apply(window);
        Monitor monitor = GlfwUtils.tryGetMonitor(window).orElse(null);
        if (monitor == null) {
            log.error("Window's monitor could not be retrieved");
        } else {
            VideoMode videoMode = monitor.m_84950_();
            String name = GlfwUtils.getMonitorName(monitor);
            int x = monitor.m_84951_();
            int y = monitor.m_84952_();
            int width = videoMode.m_85332_();
            int height = videoMode.m_85335_();
            log.info("Apply on monitor {} at ({}|{}) size ({} x {})", (Object)name, (Object)x, (Object)y, (Object)width, (Object)height);
            GlfwUtils.disableWindowAttribute(window, GlfwWindowAttribute.DECORATED);
            GLFW.glfwSetWindowMonitor((long)window.m_85439_(), (long)0L, (int)x, (int)y, (int)width, (int)height, (int)-1);
        }
    }

    @Override
    public void reset(@Nonnull Window window) {
        FullscreenDisplayMode.super.reset(window);
        if (window.m_85440_()) {
            Monitor monitor = GlfwUtils.tryGetMonitor(window).orElse(null);
            if (monitor == null) {
                log.error("Window's monitor could not be retrieved");
            } else {
                VideoMode videoMode = monitor.m_84950_();
                String name = GlfwUtils.getMonitorName(monitor);
                int width = videoMode.m_85332_();
                int height = videoMode.m_85335_();
                log.info("Reset on monitor {} at size ({} x {})", (Object)name, (Object)width, (Object)height);
                GLFW.glfwSetWindowMonitor((long)window.m_85439_(), (long)monitor.m_84954_(), (int)0, (int)0, (int)width, (int)height, (int)-1);
            }
        }
    }
}

