/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class RenderUtils {
    public static void renderLinesWrapped(PoseStack matrix, int x, int y, FormattedText text, int textWidth) {
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        RenderUtils.renderLinesWrapped(matrix, font, x, y, 9, 0, text, textWidth);
    }

    public static void renderLinesWrapped(PoseStack matrix, Font fontRenderer, int x, int y, int spacing, int defaultColor, FormattedText text, int textWidth) {
        RenderUtils.renderLinesWrapped(matrix, fontRenderer, x, y, spacing, defaultColor, fontRenderer.m_92923_(text, textWidth));
    }

    public static void renderLinesWrapped(PoseStack matrix, Font fontRenderer, int x, int y, int spacing, int defaultColor, List<FormattedCharSequence> lines) {
        for (int lineNum = 0; lineNum < lines.size(); ++lineNum) {
            FormattedCharSequence lineFragment = lines.get(lineNum);
            fontRenderer.m_92877_(matrix, lineFragment, (float)x, (float)(y + lineNum * spacing), defaultColor);
        }
    }

    public static int renderLinesReversed(PoseStack matrix, int x, int y, FormattedText text, int textWidth) {
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        return RenderUtils.renderLinesReversed(matrix, font, x, y, 9, 0xFFFFFF, text, textWidth);
    }

    public static int renderLinesReversed(PoseStack matrix, Font fontRenderer, int x, int y, int spacing, int defaultColor, FormattedText text, int textWidth) {
        return RenderUtils.renderLinesReversed(matrix, fontRenderer, x, y, spacing, defaultColor, fontRenderer.m_92923_(text, textWidth));
    }

    public static int renderLinesReversed(PoseStack matrix, Font fontRenderer, int x, int y, int spacing, int defaultColor, List<FormattedCharSequence> lines) {
        int lineCount = lines.size();
        for (int lineNum = lineCount - 1; lineNum >= 0; --lineNum) {
            FormattedCharSequence lineFragment = lines.get(lineCount - 1 - lineNum);
            fontRenderer.m_92877_(matrix, lineFragment, (float)x, (float)(y - (lineNum + 1) * (spacing + 1)), defaultColor);
        }
        return lineCount * (spacing + 1);
    }
}

