/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SimpleTip
implements ITip {
    public static final ITipSerializer<SimpleTip> SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final Component title;
    private final Component text;
    private final Optional<Integer> cycleTime;

    public SimpleTip(ResourceLocation id, Component title, Component text, Optional<Integer> cycleTime) {
        this.id = id;
        this.title = title;
        this.text = text;
        this.cycleTime = cycleTime;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public Component getText() {
        return this.text;
    }

    @Override
    public int getCycleTime() {
        return this.cycleTime.orElse(TipsModCommon.CONFIG.defaultCycleTime);
    }

    private static final class Serializer
    implements ITipSerializer<SimpleTip> {
        private Serializer() {
        }

        @Override
        public SimpleTip fromJSON(ResourceLocation id, JsonObject json) {
            Component title = (Component)Serializers.TEXT.fromJSON(json, "title", (Object)TipsAPI.DEFAULT_TITLE);
            Component text = (Component)Serializers.TEXT.fromJSON(json, "tip");
            Optional cycleTime = Serializers.INT.fromJSONOptional(json, "cycleTime");
            return new SimpleTip(id, title, text, cycleTime);
        }

        @Override
        public JsonObject toJSON(SimpleTip toWrite) {
            JsonObject json = new JsonObject();
            Serializers.RESOURCE_LOCATION.toJSON(json, "type", (Object)TipsAPI.DEFAULT_SERIALIZER);
            Serializers.TEXT.toJSON(json, "title", (Object)toWrite.title);
            Serializers.TEXT.toJSON(json, "tip", (Object)toWrite.text);
            Serializers.INT.toJSONOptional(json, "cycleTime", toWrite.cycleTime);
            return json;
        }
    }
}

