/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block;

import cy.jdkdigital.everythingcopper.common.block.entity.WeatheringStationBlockEntity;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class WeatheringStation
extends BaseEntityBlock {
    public static final BooleanProperty WET = BooleanProperty.m_61465_((String)"wet");
    private static final VoxelShape OUTER_SHAPE = Shapes.m_83144_();
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)OUTER_SHAPE, (VoxelShape)Block.m_49796_((double)2.0, (double)Math.max(2, 1), (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);

    public WeatheringStation(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WET, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WET});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new WeatheringStationBlockEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return level.f_46443_ ? null : WeatheringStation.m_152132_(entityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.WEATHERING_STATION.get()), WeatheringStationBlockEntity::tick);
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState p_51973_, BlockGetter p_51974_, BlockPos p_51975_, CollisionContext p_51976_) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState p_51969_, BlockGetter p_51970_, BlockPos p_51971_) {
        return OUTER_SHAPE;
    }

    public VoxelShape m_5939_(BlockState p_51990_, BlockGetter p_51991_, BlockPos p_51992_, CollisionContext p_51993_) {
        return SHAPE;
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.m_5776_() && (blockEntity = world.m_7702_(pos)) instanceof WeatheringStationBlockEntity) {
            WeatheringStationBlockEntity weatheringStationBlockEntity = (WeatheringStationBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            AtomicBoolean hasInteracted = new AtomicBoolean(false);
            weatheringStationBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                ItemStack outputItem = h.getStackInSlot(WeatheringStationBlockEntity.SLOT_OUTPUT);
                if (heldItem.m_41619_()) {
                    if (!outputItem.m_41619_()) {
                        player.m_21008_(hand, outputItem.m_41777_());
                        outputItem.m_41764_(0);
                        hasInteracted.set(true);
                    } else {
                        ItemStack inputItem = h.getStackInSlot(WeatheringStationBlockEntity.SLOT_INPUT);
                        player.m_21008_(hand, inputItem.m_41777_());
                        inputItem.m_41764_(0);
                        hasInteracted.set(true);
                    }
                } else if (ItemStack.m_41746_((ItemStack)heldItem, (ItemStack)outputItem)) {
                    int grabbedCount = Math.min(heldItem.m_41741_() - heldItem.m_41613_(), outputItem.m_41613_());
                    heldItem.m_41769_(grabbedCount);
                    outputItem.m_41774_(grabbedCount);
                    hasInteracted.set(true);
                } else if (h.isItemValid(WeatheringStationBlockEntity.SLOT_INPUT, heldItem)) {
                    ItemStack leftOver = h.insertItem(WeatheringStationBlockEntity.SLOT_INPUT, heldItem, false);
                    player.m_21008_(hand, leftOver);
                    hasInteracted.set(true);
                } else if (heldItem.m_150930_(Items.f_42447_)) {
                    weatheringStationBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(f -> {
                        if (f.getTankCapacity(0) - f.getFluidInTank(0).getAmount() >= 1000) {
                            f.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                            if (!player.m_7500_()) {
                                player.m_21008_(hand, heldItem.getCraftingRemainingItem());
                            }
                            hasInteracted.set(true);
                        }
                    });
                }
            });
            if (hasInteracted.get()) {
                weatheringStationBlockEntity.m_6596_();
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.m_60734_() != newState.m_60734_() && (tileEntity = worldIn.m_7702_(pos)) != null) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(slot));
                }
            });
        }
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
    }
}

