/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.entity;

import cy.jdkdigital.everythingcopper.common.entity.CopperGolem;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;

public interface IWeatheringEntity {
    public static final EntityDataAccessor<String> DATA_WEATHER_STATE = SynchedEntityData.m_135353_(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> DATA_WAXED = SynchedEntityData.m_135353_(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SynchedEntityData getSyncData();

    default public void defineData() {
        this.getSyncData().m_135372_(DATA_WEATHER_STATE, (Object)WeatheringCopper.WeatherState.UNAFFECTED.name());
        this.getSyncData().m_135372_(DATA_WAXED, (Object)false);
    }

    default public WeatheringCopper.WeatherState getAge() {
        return WeatheringCopper.WeatherState.valueOf((String)((String)this.getSyncData().m_135370_(DATA_WEATHER_STATE)));
    }

    default public void setAge(WeatheringCopper.WeatherState age) {
        this.getSyncData().m_135381_(DATA_WEATHER_STATE, (Object)age.name());
    }

    default public boolean isWaxed() {
        return (Boolean)this.getSyncData().m_135370_(DATA_WAXED);
    }

    default public void setWaxed(boolean waxed) {
        this.getSyncData().m_135381_(DATA_WAXED, (Object)waxed);
    }

    default public void saveWeatheredState(CompoundTag tag) {
        tag.m_128359_("weathering", (String)this.getSyncData().m_135370_(DATA_WEATHER_STATE));
        tag.m_128379_("waxed", ((Boolean)this.getSyncData().m_135370_(DATA_WAXED)).booleanValue());
    }

    default public void loadWeatheredState(CompoundTag tag) {
        if (tag.m_128441_("weathering") && !tag.m_128461_("weathering").isEmpty()) {
            this.setAge(WeatheringCopper.WeatherState.valueOf((String)tag.m_128461_("weathering")));
        }
        if (tag.m_128441_("waxed")) {
            this.getSyncData().m_135381_(DATA_WAXED, (Object)tag.m_128471_("waxed"));
        }
    }

    default public InteractionResult itemUse(Level level, ItemStack itemStack, Player player, BlockPos pos) {
        if (!this.isWaxed() && itemStack.m_41720_() instanceof HoneycombItem) {
            if (!level.m_5776_()) {
                this.setWaxed(true);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            level.m_5898_(player, 3003, pos.m_7494_(), 0);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemStack.m_41720_() instanceof AxeItem) {
            if (this.isWaxed()) {
                if (!level.m_5776_()) {
                    this.setWaxed(false);
                }
                level.m_5594_(player, pos.m_7494_(), SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3004, pos.m_7494_(), 0);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!this.getAge().equals((Object)WeatheringCopper.WeatherState.UNAFFECTED)) {
                if (!level.m_5776_()) {
                    this.setAge(WeatheringUtils.prevState(this.getAge()));
                }
                level.m_5594_(player, pos.m_7494_(), SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3005, pos.m_7494_(), 0);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    default public float speedModifier() {
        float speedModifier = 1.0f;
        switch (this.getAge()) {
            case UNAFFECTED: {
                speedModifier = 1.1f;
                break;
            }
            case WEATHERED: {
                speedModifier = 0.9f;
                break;
            }
            case OXIDIZED: {
                speedModifier = 0.8f;
            }
        }
        return speedModifier;
    }

    default public boolean canAge() {
        return !this.isWaxed() && !this.getAge().equals((Object)WeatheringCopper.WeatherState.OXIDIZED);
    }
}

