/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.item;

import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public interface ICopperItem {
    public static final Tier COPPER_TIER = new Tier(){

        public int m_6609_() {
            return 180;
        }

        public float m_6624_() {
            return 7.0f;
        }

        public float m_6631_() {
            return 1.8f;
        }

        public int m_6604_() {
            return 2;
        }

        public int m_6601_() {
            return 18;
        }

        public Ingredient m_6282_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_});
        }
    };
    public static final ArmorMaterial COPPER_MATERIAL = new ArmorMaterial(){

        public int m_7366_(EquipmentSlot slot) {
            int[] HEALTH_PER_SLOT = new int[]{12, 14, 15, 10};
            return HEALTH_PER_SLOT[slot.m_20749_()] * 12;
        }

        public int m_7365_(EquipmentSlot slot) {
            int[] def = new int[]{2, 4, 5, 2};
            return def[slot.m_20749_()];
        }

        public int m_6646_() {
            return 12;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11677_;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_});
        }

        public String m_6082_() {
            return "copper";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.1f;
        }
    };

    default public void weatheringTick(ItemStack stack, Level level) {
        if (ICopperItem.canAge(stack) && level.f_46441_.m_188501_() < 1.8962963E-4f) {
            ICopperItem.setAge(stack, WeatheringUtils.nextState(ICopperItem.getAge(stack)));
        }
    }

    public static boolean isWaxed(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("waxed")) {
            return tag.m_128471_("waxed");
        }
        return false;
    }

    public static void setWaxed(ItemStack stack, boolean waxed) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("waxed", waxed);
        stack.m_41751_(tag);
    }

    public static boolean canAge(ItemStack stack) {
        return !ICopperItem.isWaxed(stack) && !ICopperItem.getAge(stack).equals("oxidized");
    }

    public static String getAge(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("state") && !tag.m_128461_("state").isEmpty()) {
            return tag.m_128461_("state");
        }
        return "unaffected";
    }

    public static void setAge(ItemStack stack, String age) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("state", age);
        stack.m_41751_(tag);
    }

    public static Float getStateAsFloat(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("state") && !tag.m_128461_("state").isEmpty()) {
            return switch (tag.m_128461_("state")) {
                case "exposed" -> Float.valueOf(1.0f);
                case "weathered" -> Float.valueOf(2.0f);
                case "oxidized" -> Float.valueOf(3.0f);
                default -> Float.valueOf(0.0f);
            };
        }
        return Float.valueOf(0.0f);
    }
}

