/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.event.loot;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.everythingcopper.common.block.IWeatheringBlock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CopperBlockLootModifier
extends LootModifier {
    public static final Supplier<Codec<CopperBlockLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> CopperBlockLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("addition").forGetter(m -> m.addition), (App)Codec.INT.fieldOf("count").forGetter(m -> m.count))).apply((Applicative)inst, CopperBlockLootModifier::new)));
    private final Item addition;
    private final int count;

    protected CopperBlockLootModifier(LootItemCondition[] conditionsIn, Item addition, Integer count) {
        super(conditionsIn);
        this.addition = addition;
        this.count = count;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Item item;
        if (context.m_230907_().m_188499_() && (item = this.addition) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            for (int i = 0; i < context.m_230907_().m_188503_(5); ++i) {
                block = IWeatheringBlock.getNext(block).orElse(block);
            }
            ItemStack loot = new ItemStack((ItemLike)block.m_5456_(), this.count);
            generatedLoot.add((Object)loot);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

