/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.advancement.BooleanPredicate;
import io.github.mortuusars.exposure.advancement.predicate.EntityInFramePredicate;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class ExposurePredicate {
    public static final ExposurePredicate ANY = new ExposurePredicate(BooleanPredicate.ANY, MinMaxBounds.Doubles.f_154779_, MinMaxBounds.Doubles.f_154779_, NbtPredicate.f_57471_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EntityInFramePredicate.ANY);
    private final BooleanPredicate owner;
    private final MinMaxBounds.Doubles shutterSpeedMS;
    private final MinMaxBounds.Doubles focalLength;
    private final NbtPredicate nbt;
    private final MinMaxBounds.Ints lightLevel;
    private final MinMaxBounds.Ints entitiesInFrameCount;
    private final EntityInFramePredicate entityInFrame;

    public ExposurePredicate(BooleanPredicate ownerPredicate, MinMaxBounds.Doubles shutterSpeedMS, MinMaxBounds.Doubles focalLength, NbtPredicate nbtPredicate, MinMaxBounds.Ints lightLevel, MinMaxBounds.Ints entitiesInFrameCount, EntityInFramePredicate entityInFramePredicate) {
        this.owner = ownerPredicate;
        this.shutterSpeedMS = shutterSpeedMS;
        this.focalLength = focalLength;
        this.nbt = nbtPredicate;
        this.lightLevel = lightLevel;
        this.entitiesInFrameCount = entitiesInFrameCount;
        this.entityInFrame = entityInFramePredicate;
    }

    public boolean matches(ServerPlayer player, CompoundTag tag) {
        if (!this.ownerMatches(player, tag)) {
            return false;
        }
        if (!this.shutterSpeedMS.m_154810_((double)tag.m_128457_("ShutterSpeedMS"))) {
            return false;
        }
        if (!this.focalLength.m_154810_((double)tag.m_128457_("FocalLength"))) {
            return false;
        }
        if (!this.nbt.m_57483_((Tag)tag)) {
            return false;
        }
        if (!this.lightLevel.m_55390_(tag.m_128451_("LightLevel"))) {
            return false;
        }
        return this.entitiesMatch(player, tag);
    }

    private boolean ownerMatches(ServerPlayer player, CompoundTag tag) {
        if (this.owner.equals(BooleanPredicate.ANY)) {
            return true;
        }
        if (!tag.m_128425_("PhotographerId", 11)) {
            return false;
        }
        UUID photographerId = tag.m_128342_("PhotographerId");
        UUID playerId = player.m_20148_();
        return this.owner.matches(photographerId.equals(playerId));
    }

    private boolean entitiesMatch(ServerPlayer player, CompoundTag tag) {
        if (tag.m_128425_("Entities", 9)) {
            ListTag entities = tag.m_128437_("Entities", 10);
            if (!this.entitiesInFrameCount.m_55390_(entities.size())) {
                return false;
            }
            for (int i = 0; i < entities.size(); ++i) {
                if (!this.entityInFrame.matches(player, entities.m_128728_(i))) continue;
                return true;
            }
        } else {
            return this.entityInFrame.equals(EntityInFramePredicate.ANY) && this.entitiesInFrameCount.m_55390_(0);
        }
        return false;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        if (!this.owner.equals(BooleanPredicate.ANY)) {
            json.add("owner", this.owner.serializeToJson());
        }
        if (!this.shutterSpeedMS.m_55327_()) {
            json.add("shutter_speed_ms", this.shutterSpeedMS.m_55328_());
        }
        if (!this.focalLength.m_55327_()) {
            json.add("focal_length", this.focalLength.m_55328_());
        }
        if (!this.nbt.equals(NbtPredicate.f_57471_)) {
            json.add("nbt", this.nbt.m_57476_());
        }
        if (!this.lightLevel.m_55327_()) {
            json.add("light_level", this.lightLevel.m_55328_());
        }
        if (!this.entitiesInFrameCount.m_55327_()) {
            json.add("entities_count", this.entitiesInFrameCount.m_55328_());
        }
        if (!this.entityInFrame.equals(EntityInFramePredicate.ANY)) {
            json.add("entity_in_frame", this.entityInFrame.serializeToJson());
        }
        return json;
    }

    public static ExposurePredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)"exposure");
        return new ExposurePredicate(BooleanPredicate.fromJson(jsonobject.get("owner")), MinMaxBounds.Doubles.m_154791_((JsonElement)jsonobject.get("shutter_speed_ms")), MinMaxBounds.Doubles.m_154791_((JsonElement)jsonobject.get("focal_length")), NbtPredicate.m_57481_((JsonElement)jsonobject.get("nbt")), MinMaxBounds.Ints.m_55373_((JsonElement)jsonobject.get("light_level")), MinMaxBounds.Ints.m_55373_((JsonElement)jsonobject.get("entities_count")), EntityInFramePredicate.fromJson(jsonobject.get("entity_in_frame")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExposurePredicate that = (ExposurePredicate)o;
        return Objects.equals(this.owner, that.owner) && Objects.equals(this.shutterSpeedMS, that.shutterSpeedMS) && Objects.equals(this.focalLength, that.focalLength) && Objects.equals(this.nbt, that.nbt) && Objects.equals(this.entitiesInFrameCount, that.entitiesInFrameCount) && Objects.equals(this.entityInFrame, that.entityInFrame);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.shutterSpeedMS, this.focalLength, this.nbt, this.entitiesInFrameCount, this.entityInFrame);
    }
}

