/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.block;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;

    public LightroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockentity;
        if (pStack.m_41788_() && (blockentity = pLevel.m_7702_(pPos)) instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockentity;
            lightroomBlockEntity.m_58638_(pStack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof LightroomBlockEntity) {
                LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Containers.m_19002_((Level)serverLevel, (BlockPos)pos, (Container)lightroomBlockEntity);
                    lightroomBlockEntity.dropStoredExperience(null);
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState blockState, Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LightroomBlockEntity) {
            Item item;
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
            ItemStack filmStack = lightroomBlockEntity.m_8020_(0);
            if (filmStack.m_41619_() || !filmStack.m_41782_() || !((item = filmStack.m_41720_()) instanceof DevelopedFilmItem)) {
                return 0;
            }
            DevelopedFilmItem developedFilmItem = (DevelopedFilmItem)item;
            int exposedFrames = developedFilmItem.getExposedFramesCount(filmStack);
            int currentFrame = lightroomBlockEntity.getSelectedFrameIndex();
            return Mth.m_14143_((float)(((float)currentFrame + 1.0f) / (float)exposedFrames * 14.0f)) + 1;
        }
        return 0;
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof LightroomBlockEntity)) {
            return InteractionResult.FAIL;
        }
        LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
        player.m_36220_(Exposure.Stats.INTERACT_WITH_LIGHTROOM);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            lightroomBlockEntity.m_6596_();
            PlatformHelper.openMenu(serverPlayer, (MenuProvider)lightroomBlockEntity, buffer -> buffer.m_130064_(pos));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6861_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean pIsMoving) {
        if (!level.f_46443_ && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            for (Direction direction : Direction.values()) {
                BlockEntity blockEntity;
                BlockPos relative = pos.m_121945_(direction);
                if (!relative.equals((Object)fromPos) || level.m_46681_(relative, direction) <= 0 || !((blockEntity = level.m_7702_(pos)) instanceof LightroomBlockEntity)) continue;
                LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
                lightroomBlockEntity.startPrintingProcess(true);
                return;
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return LightroomBlock.createBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return LightroomBlock.getBlockTicker(level, state, blockEntityType);
    }

    public static BlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        return new LightroomBlockEntity(pos, state);
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getBlockTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.f_46443_ && blockEntityType.equals(Exposure.BlockEntityTypes.LIGHTROOM.get())) {
            return LightroomBlockEntity::serverTick;
        }
        return null;
    }
}

