/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.camera.capture.converter.IImageToMapColorsConverter;
import io.github.mortuusars.exposure.camera.capture.converter.SimpleColorConverter;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.util.ColorUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;

public class Capture {
    private FilmType type = FilmType.COLOR;
    private int size = 320;
    private float cropFactor = 1.142857f;
    private float brightnessStops = 0.0f;
    private boolean asyncProcessing = true;
    private Collection<ICaptureComponent> components = Collections.emptyList();
    private IImageToMapColorsConverter converter = new SimpleColorConverter();
    private int ticksDelay = -1;
    private int framesDelay = -1;
    private long captureTick;
    private boolean completed = false;
    private long currentTick;

    public boolean isCompleted() {
        return this.completed;
    }

    public int getTicksDelay() {
        return (int)(this.captureTick - Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_());
    }

    public int getFramesDelay() {
        return this.framesDelay;
    }

    public FilmType getFilmType() {
        return this.type;
    }

    public Capture setFilmType(FilmType type) {
        this.type = type;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Capture setSize(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"'size' cannot be less or equal to 0.");
        this.size = size;
        return this;
    }

    public float getCropFactor() {
        return this.cropFactor;
    }

    public Capture cropFactor(float cropFactor) {
        Preconditions.checkArgument((cropFactor != 0.0f ? 1 : 0) != 0, (Object)"'cropFactor' cannot be 0.");
        this.cropFactor = cropFactor;
        return this;
    }

    public float getBrightnessStops() {
        return this.brightnessStops;
    }

    public Capture setBrightnessStops(float brightnessStops) {
        this.brightnessStops = brightnessStops;
        return this;
    }

    public Capture setAsyncProcessing(boolean asyncProcessing) {
        this.asyncProcessing = asyncProcessing;
        return this;
    }

    public Capture addComponents(ICaptureComponent ... components) {
        this.components = List.of(components);
        return this;
    }

    public Capture addComponents(Collection<ICaptureComponent> components) {
        this.components = components;
        return this;
    }

    public Capture setConverter(IImageToMapColorsConverter converter) {
        this.converter = converter;
        return this;
    }

    public void initialize() {
        for (ICaptureComponent modifier : this.components) {
            this.ticksDelay = Math.max(this.ticksDelay, modifier.getTicksDelay(this));
            this.framesDelay = Math.max(this.framesDelay, modifier.getFramesDelay(this));
        }
        for (ICaptureComponent modifier : this.components) {
            modifier.initialize(this);
        }
        this.currentTick = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_();
        this.captureTick = this.currentTick + (long)this.ticksDelay;
        if (this.currentTick == this.captureTick && this.framesDelay <= 0) {
            for (ICaptureComponent modifier : this.components) {
                modifier.onDelayTick(this, 0);
                modifier.onDelayFrame(this, 0);
            }
        }
    }

    public void tick() {
        long lastTick = this.currentTick;
        this.currentTick = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_();
        if (this.ticksDelay > 0) {
            if (lastTick < this.currentTick) {
                --this.ticksDelay;
                for (ICaptureComponent modifier : this.components) {
                    modifier.onDelayTick(this, this.ticksDelay);
                }
                if (this.ticksDelay == 0 && this.framesDelay == 0) {
                    for (ICaptureComponent modifier : this.components) {
                        modifier.onDelayFrame(this, 0);
                    }
                }
            }
            return;
        }
        if (this.framesDelay > 0) {
            --this.framesDelay;
            for (ICaptureComponent modifier : this.components) {
                modifier.onDelayFrame(this, this.framesDelay);
            }
            return;
        }
        NativeImage screenshot = Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_());
        for (ICaptureComponent modifier : this.components) {
            modifier.screenshotTaken(this, screenshot);
        }
        if (this.asyncProcessing) {
            new Thread(() -> this.processImage(screenshot), "ExposureProcessing").start();
        } else {
            this.processImage(screenshot);
        }
        this.completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void processImage(NativeImage screenshotImage) {
        block16: {
            try {
                image = this.scaleCropAndProcess(screenshotImage);
                for (Object component : this.components) {
                    image = component.modifyImage(this, (BufferedImage)image);
                }
                pixels = this.converter.convert(this, (BufferedImage)image);
                for (ICaptureComponent component : this.components) {
                    component.teardown(this);
                }
                properties = new CompoundTag();
                properties.m_128359_("Type", this.getFilmType().m_7912_());
                for (ICaptureComponent component : this.components) {
                    component.save(pixels, image.getWidth(), image.getHeight(), properties);
                }
                ** try [egrp 1[TRYBLOCK] [0 : 184->226)] { 
            }
            catch (Exception e) {
                LogUtils.getLogger().error(e.toString());
                break block16;
            }
            finally {
                try {
                    for (ICaptureComponent component : this.components) {
                        component.end(this);
                    }
                }
                catch (Exception e) {
                    LogUtils.getLogger().error(e.toString());
                }
            }
lbl-1000:
            // 2 sources

            {
                for (ICaptureComponent component : this.components) {
                    component.end(this);
                }
                break block16;
            }
lbl21:
            // 1 sources

            catch (Exception e) {
                LogUtils.getLogger().error(e.toString());
            }
        }
    }

    private BufferedImage scaleCropAndProcess(NativeImage sourceImage) {
        int sWidth = sourceImage.m_84982_();
        int sHeight = sourceImage.m_85084_();
        int sourceSize = Math.min(sWidth, sHeight);
        float crop = (float)sourceSize - (float)sourceSize / this.getCropFactor();
        sourceSize -= (int)crop;
        int sourceXStart = sWidth > sHeight ? (sWidth - sHeight) / 2 : 0;
        int sourceYStart = sHeight > sWidth ? (sHeight - sWidth) / 2 : 0;
        sourceXStart += (int)(crop / 2.0f);
        sourceYStart += (int)(crop / 2.0f);
        int size = this.getSize();
        BufferedImage bufferedImage = new BufferedImage(size, size, 1);
        try (NativeImage nativeImage = sourceImage;){
            for (int x = 0; x < size; ++x) {
                float sourceX = (float)sourceSize * ((float)x / (float)size);
                int sx = Mth.m_14045_((int)((int)sourceX + sourceXStart), (int)sourceXStart, (int)(sourceXStart + sourceSize));
                for (int y = 0; y < size; ++y) {
                    float sourceY = (float)sourceSize * ((float)y / (float)size);
                    int sy = Mth.m_14045_((int)((int)sourceY + sourceYStart), (int)sourceYStart, (int)(sourceYStart + sourceSize));
                    int rgba = ColorUtils.BGRtoRGB(sourceImage.m_84985_(sx, sy));
                    Color pixel = new Color(rgba, false);
                    for (ICaptureComponent component : this.components) {
                        pixel = component.modifyPixel(this, pixel.getRed(), pixel.getGreen(), pixel.getBlue());
                    }
                    bufferedImage.setRGB(x, y, 0xFF000000 | pixel.getRed() << 16 | pixel.getGreen() << 8 | pixel.getBlue());
                }
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Failed to create an image: " + e);
        }
        return bufferedImage;
    }
}

