/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.exposure.command.argument.ShaderLocationArgument;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.ApplyShaderS2CP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ShaderCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"shader").requires(stack -> stack.m_6761_(2))).then(Commands.m_82127_((String)"apply").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"shaderLocation", (ArgumentType)new ShaderLocationArgument()).executes(ShaderCommand::applyShader))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ShaderCommand::removeShader))));
    }

    private static int applyShader(CommandContext<CommandSourceStack> context) {
        ResourceLocation shaderLocation = ResourceLocationArgument.m_107011_(context, (String)"shaderLocation");
        for (ServerPlayer targetPlayer : ShaderCommand.getTargetPlayers(context)) {
            Packets.sendToClient(new ApplyShaderS2CP(shaderLocation), targetPlayer);
        }
        return 0;
    }

    private static int removeShader(CommandContext<CommandSourceStack> context) {
        ResourceLocation shaderLocation = new ResourceLocation("minecraft:none");
        for (ServerPlayer targetPlayer : ShaderCommand.getTargetPlayers(context)) {
            Packets.sendToClient(new ApplyShaderS2CP(shaderLocation), targetPlayer);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"command.exposure.shader.removed"), false);
        }
        return 0;
    }

    private static List<ServerPlayer> getTargetPlayers(CommandContext<CommandSourceStack> context) {
        try {
            return new ArrayList<ServerPlayer>(EntityArgument.m_91477_(context, (String)"targets"));
        }
        catch (CommandSyntaxException e) {
            return Collections.emptyList();
        }
    }
}

