/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class Filters {
    private static ConcurrentMap<Ingredient, ResourceLocation> filters = new ConcurrentHashMap<Ingredient, ResourceLocation>();

    public static void reload(ConcurrentMap<Ingredient, ResourceLocation> newFilters) {
        filters.clear();
        filters = newFilters;
    }

    public static Optional<ResourceLocation> getShaderOf(ItemStack stack) {
        for (Map.Entry filter : filters.entrySet()) {
            if (!((Ingredient)filter.getKey()).test(stack)) continue;
            return Optional.of((ResourceLocation)filter.getValue());
        }
        return Optional.empty();
    }
}

