/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.forge.event;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.capture.CaptureManager;
import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.client.ExposureClientReloadListener;
import io.github.mortuusars.exposure.client.MouseHandler;
import io.github.mortuusars.exposure.data.FiltersResourceLoader;
import io.github.mortuusars.exposure.gui.component.PhotographTooltip;
import io.github.mortuusars.exposure.gui.screen.LightroomScreen;
import io.github.mortuusars.exposure.gui.screen.album.AlbumScreen;
import io.github.mortuusars.exposure.gui.screen.album.LecternAlbumScreen;
import io.github.mortuusars.exposure.gui.screen.camera.CameraAttachmentsScreen;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.CameraItemClientExtensions;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.render.ItemFramePhotographRenderer;
import io.github.mortuusars.exposure.render.PhotographEntityRenderer;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientEvents {

    public static class ForgeBus {
        @SubscribeEvent
        public static void onLevelClear(LevelEvent.Unload event) {
            ExposureClient.getExposureRenderer().clearData();
        }

        @SubscribeEvent
        public static void loggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
            ExposureClient.getExposureStorage().clear();
        }

        @SubscribeEvent
        public static void renderOverlay(RenderGuiOverlayEvent.Pre event) {
            if (ViewfinderClient.isLookingThrough()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void mouseScroll(InputEvent.MouseScrollingEvent event) {
            if (ViewfinderClient.handleMouseScroll(event.getScrollDelta() > 0.0 ? ZoomDirection.IN : ZoomDirection.OUT)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void computeFOV(ViewportEvent.ComputeFov event) {
            double modifiedFov;
            if (!event.usedConfiguredFov()) {
                return;
            }
            double prevFov = event.getFOV();
            if (prevFov != (modifiedFov = ViewfinderClient.modifyFov(prevFov))) {
                event.setFOV(modifiedFov);
            }
        }

        @SubscribeEvent
        public static void onMouseButtonPre(InputEvent.MouseButton.Pre event) {
            if (MouseHandler.handleMouseButtonPress(event.getButton(), event.getAction(), event.getModifiers())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void renderItemFrameItem(RenderItemInFrameEvent event) {
            if (ItemFramePhotographRenderer.render(event.getItemFrameEntity(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onRenderTick(TickEvent.RenderTickEvent event) {
            if (!event.phase.equals((Object)TickEvent.Phase.END)) {
                return;
            }
            CaptureManager.onRenderTickEnd();
        }
    }

    public static class ModBus {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ExposureClient.init();
                MenuScreens.m_96206_(Exposure.MenuTypes.CAMERA.get(), CameraAttachmentsScreen::new);
                MenuScreens.m_96206_(Exposure.MenuTypes.ALBUM.get(), AlbumScreen::new);
                MenuScreens.m_96206_(Exposure.MenuTypes.LECTERN_ALBUM.get(), LecternAlbumScreen::new);
                MenuScreens.m_96206_(Exposure.MenuTypes.LIGHTROOM.get(), LightroomScreen::new);
                ItemProperties.register((Item)Exposure.Items.CAMERA.get(), (ResourceLocation)new ResourceLocation("camera_state"), CameraItemClientExtensions::itemPropertyFunction);
                ItemProperties.register((Item)Exposure.Items.CHROMATIC_SHEET.get(), (ResourceLocation)new ResourceLocation("channels"), (stack, clientLevel, livingEntity, seed) -> {
                    float f;
                    Item patt2858$temp = stack.m_41720_();
                    if (patt2858$temp instanceof ChromaticSheetItem) {
                        ChromaticSheetItem chromaticSheet = (ChromaticSheetItem)patt2858$temp;
                        f = (float)chromaticSheet.getExposures(stack).size() / 10.0f;
                    } else {
                        f = 0.0f;
                    }
                    return f;
                });
                ItemProperties.register((Item)Exposure.Items.STACKED_PHOTOGRAPHS.get(), (ResourceLocation)new ResourceLocation("count"), (stack, clientLevel, livingEntity, seed) -> {
                    float f;
                    Item patt3225$temp = stack.m_41720_();
                    if (patt3225$temp instanceof StackedPhotographsItem) {
                        StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)patt3225$temp;
                        f = (float)stackedPhotographsItem.getPhotographsCount(stack) / 100.0f;
                    } else {
                        f = 0.0f;
                    }
                    return f;
                });
                ItemProperties.register((Item)Exposure.Items.ALBUM.get(), (ResourceLocation)new ResourceLocation("photos"), (stack, clientLevel, livingEntity, seed) -> {
                    float f;
                    Item patt3608$temp = stack.m_41720_();
                    if (patt3608$temp instanceof AlbumItem) {
                        AlbumItem albumItem = (AlbumItem)patt3608$temp;
                        f = (float)albumItem.getPhotographsCount(stack) / 100.0f;
                    } else {
                        f = 0.0f;
                    }
                    return f;
                });
            });
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(Exposure.EntityTypes.PHOTOGRAPH.get(), PhotographEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(PhotographTooltip.class, photographTooltip -> photographTooltip);
        }

        @SubscribeEvent
        public static void registerResourceReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new ExposureClientReloadListener());
            event.registerReloadListener((PreparableReloadListener)new FiltersResourceLoader());
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            event.register((ResourceLocation)new ModelResourceLocation("exposure", "camera_gui", "inventory"));
        }

        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            ExposureClient.registerKeymappings(key -> {
                event.register(key);
                return key;
            });
        }
    }
}

