/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.forge.mixin;

import io.github.mortuusars.exposure.forge.item.CameraItemForgeClientExtensions;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItem;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CameraItem.class}, remap=false)
public abstract class CameraItemForgeMixin
extends Item
implements IForgeItem {
    public CameraItemForgeMixin(Item.Properties properties) {
        super(properties);
    }

    @Shadow
    abstract InteractionResult useCamera(Player var1, InteractionHand var2);

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            InteractionHand hand = context.m_43724_();
            if (hand == InteractionHand.MAIN_HAND && CameraInHand.getActiveHand(player) == InteractionHand.OFF_HAND) {
                return InteractionResult.PASS;
            }
            return this.useCamera(player, hand);
        }
        return InteractionResult.CONSUME;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_());
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(CameraItemForgeClientExtensions.INSTANCE);
    }
}

