/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.gui.screen.element.Pager;
import io.github.mortuusars.exposure.render.ExposureImage;
import io.github.mortuusars.exposure.render.ExposureTexture;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.util.GuiUtil;
import io.github.mortuusars.exposure.util.PagingDirection;
import java.util.List;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NegativeExposureScreen
extends ZoomableScreen {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/film_frame_inspect.png");
    public static final int BG_SIZE = 78;
    public static final int FRAME_SIZE = 54;
    private final Pager pager = new Pager(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());
    private final List<Either<String, ResourceLocation>> exposures;

    public NegativeExposureScreen(List<Either<String, ResourceLocation>> exposures) {
        super((Component)Component.m_237119_());
        this.exposures = exposures;
        Preconditions.checkArgument((exposures != null && !exposures.isEmpty() ? 1 : 0) != 0);
        this.zoom.step = 2.0f;
        this.zoom.defaultZoom = 1.0f;
        this.zoom.targetZoom = 1.0f;
        this.zoom.minZoom = this.zoom.defaultZoom / (float)Math.pow(this.zoom.step, 1.0);
        this.zoom.maxZoom = this.zoom.defaultZoom * (float)Math.pow(this.zoom.step, 5.0);
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zoomFactor = 1.0f / (float)((Integer)this.minecraft.f_91066_.m_231928_().m_231551_() + 1);
        ImageButton previousButton = new ImageButton(0, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 0, 0, 16, PhotographScreen.WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.PREVIOUS), (Component)Component.m_237115_((String)"gui.exposure.previous_page"));
        this.m_142416_((GuiEventListener)previousButton);
        ImageButton nextButton = new ImageButton(this.f_96543_ - 16, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 16, 0, 16, PhotographScreen.WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.NEXT), (Component)Component.m_237115_((String)"gui.exposure.next_page"));
        this.m_142416_((GuiEventListener)nextButton);
        this.pager.init(this.exposures.size(), true, (AbstractButton)previousButton, (AbstractButton)nextButton);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ExposureImage exposure;
        this.pager.update();
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        Either<String, ResourceLocation> idOrTexture = this.exposures.get(this.pager.getCurrentPage());
        @Nullable FilmType type = (FilmType)((Object)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(ExposureSavedData::getType).orElse(FilmType.BLACK_AND_WHITE), texture -> texture.m_135815_().endsWith("_black_and_white") || texture.m_135815_().endsWith("_bw") ? FilmType.COLOR : FilmType.BLACK_AND_WHITE));
        if (type == null) {
            type = FilmType.BLACK_AND_WHITE;
        }
        if ((exposure = (ExposureImage)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(data -> new ExposureImage((String)id, (ExposureSavedData)((Object)((Object)data)))).orElse(null), texture -> {
            @Nullable ExposureTexture exposureTexture = ExposureTexture.getTexture(texture);
            if (exposureTexture != null) {
                return new ExposureImage(texture.toString(), exposureTexture);
            }
            return null;
        })) == null) {
            return;
        }
        int width = exposure.getWidth();
        int height = exposure.getHeight();
        poseStack.m_85836_();
        poseStack.m_85837_((double)(this.x + (float)this.f_96543_ / 2.0f), (double)(this.y + (float)this.f_96544_ / 2.0f), 0.0);
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_85837_((double)((float)(-width) / 2.0f), (double)((float)(-height) / 2.0f), 0.0);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        poseStack.m_85836_();
        float scale = Math.max((float)width / 54.0f, (float)height / 54.0f);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(-12.0, -12.0, 0.0);
        GuiUtil.blit(poseStack, 0.0f, 0.0f, 78.0f, 78.0f, 0, 0, 256, 256, 0.0f);
        RenderSystem.m_157429_((float)type.filmR, (float)type.filmG, (float)type.filmB, (float)type.filmA);
        GuiUtil.blit(poseStack, 0.0f, 0.0f, 78.0f, 78.0f, 0, 78, 256, 256, 0.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ExposureClient.getExposureRenderer().render(idOrTexture, ExposurePixelModifiers.NEGATIVE_FILM, poseStack, (MultiBufferSource)bufferSource, 0.0f, 0.0f, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, type.frameR, type.frameG, type.frameB, 255);
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }
}

