/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.album;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.exposure.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.gui.screen.element.textbox.TextBox;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.AlbumSignC2SP;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class AlbumSigningScreen
extends Screen {
    public static final int SELECTION_COLOR = -7829249;
    public static final int SELECTION_UNFOCUSED_COLOR = -4473857;
    @NotNull
    protected final Minecraft minecraft;
    @NotNull
    protected final Player player;
    protected final Screen parentScreen;
    protected final ResourceLocation texture;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int textureWidth;
    protected int textureHeight;
    protected TextBox titleTextBox;
    protected ImageButton signButton;
    protected ImageButton cancelSigningButton;
    protected String titleText = "";

    public AlbumSigningScreen(Screen screen, ResourceLocation texture, int textureWidth, int textureHeight) {
        super((Component)Component.m_237119_());
        this.parentScreen = screen;
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.minecraft = Minecraft.m_91087_();
        this.player = (Player)Objects.requireNonNull(this.minecraft.f_91074_);
    }

    protected void m_7856_() {
        this.imageWidth = 149;
        this.imageHeight = 188;
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.titleTextBox = new TextBox(this.f_96547_, this.leftPos + 21, this.topPos + 73, 108, 9, () -> this.titleText, text -> {
            this.titleText = text;
        }).setFontColor(-8036298, -8036298).setSelectionColor(-7829249, -4473857);
        this.titleTextBox.textValidator = text -> text != null && this.f_96547_.m_92920_(text, 108) <= 9 && !text.contains("\n");
        this.titleTextBox.horizontalAlignment = HorizontalAlignment.CENTER;
        this.m_142416_((GuiEventListener)this.titleTextBox);
        this.signButton = new ImageButton(this.leftPos + 46, this.topPos + 110, 22, 22, 242, 188, 22, this.texture, this.textureWidth, this.textureHeight, b -> this.signAlbum(), (b, poseStack, x, y) -> this.m_169388_(poseStack, List.of(Component.m_237115_((String)"gui.exposure.album.sign"), Component.m_237115_((String)"gui.exposure.album.sign.warning").m_130940_(ChatFormatting.GRAY)), Optional.empty(), x, y), (Component)Component.m_237115_((String)"gui.exposure.album.sign"));
        this.m_142416_((GuiEventListener)this.signButton);
        this.cancelSigningButton = new ImageButton(this.leftPos + 83, this.topPos + 111, 22, 22, 264, 188, 22, this.texture, this.textureWidth, this.textureHeight, b -> this.cancelSigning(), (b, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.exposure.album.cancel_signing"), x, y), (Component)Component.m_237115_((String)"gui.exposure.album.cancel_signing"));
        this.m_142416_((GuiEventListener)this.cancelSigningButton);
        this.m_94718_((GuiEventListener)this.titleTextBox);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        this.titleTextBox.tick();
    }

    protected void updateButtons() {
        this.signButton.f_93623_ = this.canSign();
    }

    protected boolean canSign() {
        return !this.titleText.isEmpty();
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        this.m_7333_(poseStack);
        AlbumSigningScreen.m_93143_((PoseStack)poseStack, (int)this.leftPos, (int)this.topPos, (int)0, (float)298.0f, (float)0.0f, (int)this.imageWidth, (int)this.imageHeight, (int)this.textureHeight, (int)this.textureWidth);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.renderLabels(poseStack);
    }

    private void renderLabels(@NotNull PoseStack poseStack) {
        MutableComponent component = Component.m_237115_((String)"gui.exposure.album.enter_title");
        this.f_96547_.m_92889_(poseStack, (Component)component, (float)(this.leftPos + 74 - this.f_96547_.m_92852_((FormattedText)component) / 2), (float)(this.topPos + 50), 16116688);
        component = Component.m_237110_((String)"gui.exposure.album.by_author", (Object[])new Object[]{this.player.m_7755_()});
        this.f_96547_.m_92889_(poseStack, (Component)component, (float)(this.leftPos + 74 - this.f_96547_.m_92852_((FormattedText)component) / 2), (float)(this.topPos + 84), 13087894);
    }

    protected void signAlbum() {
        if (this.canSign()) {
            Packets.sendToServer(new AlbumSignC2SP(this.titleText));
            this.m_7379_();
        }
    }

    protected void cancelSigning() {
        this.minecraft.m_91152_(this.parentScreen);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        if (keyCode == 256) {
            this.cancelSigning();
            return true;
        }
        if (this.titleTextBox.m_93696_()) {
            return this.titleTextBox.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

