/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.CompositionGuide;
import io.github.mortuusars.exposure.camera.infrastructure.CompositionGuides;
import io.github.mortuusars.exposure.camera.infrastructure.SynchronizedCameraInHandActions;
import io.github.mortuusars.exposure.gui.screen.camera.button.CycleButton;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class CompositionGuideButton
extends CycleButton {
    private final List<CompositionGuide> guides = CompositionGuides.getGuides();

    public CompositionGuideButton(Screen screen, int x, int y, int width, int height, int u, int v, ResourceLocation texture) {
        super(screen, x, y, width, height, u, v, height, texture);
        CameraInHand camera = CameraInHand.getActive((Player)Minecraft.m_91087_().f_91074_);
        Preconditions.checkState((!camera.isEmpty() ? 1 : 0) != 0, (Object)"Player must hold an active camera at this point.");
        CompositionGuide guide = camera.getItem().getCompositionGuide(camera.getStack());
        int currentGuideIndex = 0;
        for (int i = 0; i < this.guides.size(); ++i) {
            if (!this.guides.get(i).getId().equals(guide.getId())) continue;
            currentGuideIndex = i;
            break;
        }
        this.setupButtonElements(this.guides.size(), currentGuideIndex);
    }

    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Exposure.SoundEvents.CAMERA_BUTTON_CLICK.get(), (float)(Objects.requireNonNull(Minecraft.m_91087_().f_91073_).f_46441_.m_188501_() * 0.15f + 0.93f), (float)0.7f));
    }

    @Override
    public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTick);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Exposure.resource("textures/gui/viewfinder/icon/composition_guide/" + this.guides.get(this.currentIndex).getId() + ".png"));
        CompositionGuideButton.m_93143_((PoseStack)poseStack, (int)this.f_93620_, (int)(this.f_93621_ + 4), (int)0, (float)0.0f, (float)0.0f, (int)15, (int)14, (int)15, (int)14);
    }

    @Override
    public void m_7428_(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        this.screen.m_169388_(poseStack, List.of(Component.m_237115_((String)"gui.exposure.viewfinder.composition_guide.tooltip"), ((MutableComponent)this.m_6035_()).m_130940_(ChatFormatting.GRAY)), Optional.empty(), mouseX, mouseY);
    }

    @NotNull
    public Component m_6035_() {
        return this.guides.get(this.currentIndex).translate();
    }

    @Override
    protected void onCycle() {
        SynchronizedCameraInHandActions.setCompositionGuide(this.guides.get(this.currentIndex));
    }
}

