/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.exposure.gui.screen.element.IElementWithTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class CycleButton
extends ImageButton
implements IElementWithTooltip {
    protected final Screen screen;
    protected int count = 1;
    protected int currentIndex = 0;
    protected boolean loop = true;

    public CycleButton(Screen screen, int x, int y, int width, int height, int u, int v, int yDiffTex, ResourceLocation texture) {
        super(x, y, width, height, u, v, yDiffTex, texture, button -> {});
        this.screen = screen;
    }

    public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float pPartialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, pPartialTick);
    }

    @Override
    public void m_7428_(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
    }

    public void setupButtonElements(int count, int startingIndex) {
        this.count = count;
        this.currentIndex = startingIndex;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if ((button == 0 || button == 1) && this.m_93680_(mouseX, mouseY)) {
            this.cycle(button == 1);
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.cycle(delta < 0.0);
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        return true;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        boolean pressed = super.m_7933_(pKeyCode, pScanCode, pModifiers);
        if (pressed) {
            this.cycle(Screen.m_96638_());
        }
        return pressed;
    }

    protected void cycle(boolean reverse) {
        int value = this.currentIndex;
        if ((value += reverse ? -1 : 1) < 0) {
            value = this.loop ? this.count - 1 : 0;
        } else if (value >= this.count) {
            int n = value = this.loop ? 0 : this.count - 1;
        }
        if (this.currentIndex != value) {
            this.currentIndex = value;
            this.onCycle();
        }
    }

    protected void onCycle() {
    }
}

