/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.element.textbox;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.mortuusars.exposure.gui.screen.element.textbox.DisplayCache;
import io.github.mortuusars.exposure.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.util.Pos2i;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TextBox
extends AbstractWidget {
    public final Font font;
    public Supplier<String> textGetter;
    public Consumer<String> textSetter;
    public Predicate<String> textValidator = text -> {
        int n;
        if (text == null) return false;
        int n2 = this.getFont().m_92920_(text, this.f_93618_);
        if (text.endsWith("\n")) {
            Objects.requireNonNull(this.getFont());
            n = 9;
        } else {
            n = 0;
        }
        if (n2 + n > this.f_93619_) return false;
        return true;
    };
    public HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    public int fontColor = -16777216;
    public int fontUnfocusedColor = -16777216;
    public int selectionColor = -16776961;
    public int selectionUnfocusedColor = -2013265665;
    public final TextFieldHelper textFieldHelper;
    protected DisplayCache displayCache = new DisplayCache();
    protected int frameTick;
    protected long lastClickTime;
    protected int lastIndex = -1;

    public TextBox(@NotNull Font font, int x, int y, int width, int height, Supplier<String> textGetter, Consumer<String> textSetter) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.font = font;
        this.textGetter = textGetter;
        this.textSetter = textSetter;
        this.textFieldHelper = new TextFieldHelper(this::getText, this::setText, TextFieldHelper.m_95153_((Minecraft)Minecraft.m_91087_()), TextFieldHelper.m_95182_((Minecraft)Minecraft.m_91087_()), this::validateText);
    }

    public void tick() {
        ++this.frameTick;
    }

    public Font getFont() {
        return this.font;
    }

    @NotNull
    public String getText() {
        return this.textGetter.get();
    }

    public TextBox setText(@NotNull String text) {
        this.textSetter.accept(text);
        this.clearDisplayCache();
        return this;
    }

    protected boolean validateText(String text) {
        return this.textValidator.test(text);
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
        this.clearDisplayCache();
    }

    public int getCurrentFontColor() {
        return this.m_93696_() ? this.fontColor : this.fontUnfocusedColor;
    }

    public TextBox setFontColor(int fontColor, int fontUnfocusedColor) {
        this.fontColor = fontColor;
        this.fontUnfocusedColor = fontUnfocusedColor;
        this.clearDisplayCache();
        return this;
    }

    public TextBox setSelectionColor(int selectionColor, int selectionUnfocusedColor) {
        this.selectionColor = selectionColor;
        this.selectionUnfocusedColor = selectionUnfocusedColor;
        this.clearDisplayCache();
        return this;
    }

    public void setCursorToEnd() {
        this.textFieldHelper.m_95193_();
        this.clearDisplayCache();
    }

    public void refresh() {
        this.clearDisplayCache();
    }

    protected DisplayCache getDisplayCache() {
        if (this.displayCache.needsRebuilding) {
            this.displayCache.rebuild(this.font, this.getText(), this.textFieldHelper.m_95194_(), this.textFieldHelper.m_95197_(), this.f_93620_, this.f_93621_, this.m_5711_(), this.m_93694_(), this.horizontalAlignment);
        }
        return this.displayCache;
    }

    protected void clearDisplayCache() {
        this.displayCache.needsRebuilding = true;
    }

    protected Pos2i convertLocalToScreen(Pos2i pos) {
        return new Pos2i(this.f_93620_ + pos.x, this.f_93621_ + pos.y);
    }

    protected Pos2i convertScreenToLocal(Pos2i screenPos) {
        return new Pos2i(screenPos.x - this.f_93620_, screenPos.y - this.f_93621_);
    }

    public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        DisplayCache displayCache = this.getDisplayCache();
        for (DisplayCache.LineInfo lineInfo : displayCache.lines) {
            this.font.m_92889_(poseStack, lineInfo.asComponent, (float)(this.f_93620_ + lineInfo.x), (float)(this.f_93621_ + lineInfo.y), this.getCurrentFontColor());
        }
        this.renderHighlight(displayCache.selectionAreas);
        if (this.m_93696_()) {
            this.renderCursor(poseStack, displayCache.cursorPos, displayCache.cursorAtEnd);
        }
    }

    private void renderHighlight(Rect2i[] selected) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        Color color = new Color(this.m_93696_() ? this.selectionColor : this.selectionUnfocusedColor);
        RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Rect2i rect2i : selected) {
            int i = this.f_93620_ + rect2i.m_110085_();
            int j = this.f_93621_ + rect2i.m_110086_();
            int k = i + rect2i.m_110090_();
            int l = j + rect2i.m_110091_();
            bufferBuilder.m_5483_((double)i, (double)l, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)k, (double)l, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)k, (double)j, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)i, (double)j, 0.0).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69493_();
    }

    protected void renderCursor(@NotNull PoseStack poseStack, Pos2i cursorPos, boolean isEndOfText) {
        if (this.frameTick / 6 % 2 == 0) {
            cursorPos = this.convertLocalToScreen(cursorPos);
            if (isEndOfText) {
                this.font.m_92883_(poseStack, "_", (float)cursorPos.x, (float)cursorPos.y, this.getCurrentFontColor());
            } else {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 50.0);
                RenderSystem.m_69461_();
                int n = cursorPos.x;
                int n2 = cursorPos.y - 1;
                int n3 = cursorPos.x + 1;
                int n4 = cursorPos.y;
                Objects.requireNonNull(this.font);
                Screen.m_93172_((PoseStack)poseStack, (int)n, (int)n2, (int)n3, (int)(n4 + 9), (int)this.getCurrentFontColor());
                poseStack.m_85849_();
            }
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    @NotNull
    public Component m_6035_() {
        return Component.m_237113_((String)this.getText());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_93696_()) {
            return false;
        }
        boolean handled = this.handleKeyPressed(keyCode, scanCode, modifiers);
        if (handled) {
            this.clearDisplayCache();
        }
        return handled;
    }

    protected boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        TextFieldHelper.CursorStep cursorStep;
        TextFieldHelper.CursorStep cursorStep2 = cursorStep = Screen.m_96637_() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        if (keyCode == 265) {
            this.changeLine(-1);
            return true;
        }
        if (keyCode == 264) {
            this.changeLine(1);
            return true;
        }
        if (keyCode == 268) {
            this.keyHome();
            return true;
        }
        if (keyCode == 269) {
            this.keyEnd();
            return true;
        }
        if (keyCode == 259) {
            this.textFieldHelper.m_232572_(-1, cursorStep);
            return true;
        }
        if (keyCode == 261) {
            this.textFieldHelper.m_232572_(1, cursorStep);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.textFieldHelper.m_95158_(CommonComponents.f_178388_.getString());
            return true;
        }
        return this.textFieldHelper.m_95145_(keyCode);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.m_93696_()) {
            return false;
        }
        boolean typed = this.textFieldHelper.m_95143_(codePoint);
        if (typed) {
            this.clearDisplayCache();
        }
        return typed;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93622_ && this.f_93624_ && this.m_142518_() && button == 0) {
            long currentTime = Util.m_137550_();
            DisplayCache displayCache = this.getDisplayCache();
            int index = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (index >= 0) {
                if (index == this.lastIndex && currentTime - this.lastClickTime < 250L) {
                    if (!this.textFieldHelper.m_95198_()) {
                        this.selectWord(index);
                    } else {
                        this.textFieldHelper.m_95188_();
                    }
                } else {
                    this.textFieldHelper.m_95179_(index, Screen.m_96638_());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = index;
            this.lastClickTime = currentTime;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            DisplayCache displayCache = this.getDisplayCache();
            int index = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            this.textFieldHelper.m_95179_(index, true);
            this.clearDisplayCache();
        }
        return true;
    }

    public void setFocus(boolean focused) {
        this.m_93692_(focused);
    }

    protected void selectWord(int index) {
        String string = this.getText();
        this.textFieldHelper.m_95147_(StringSplitter.m_92355_((String)string, (int)-1, (int)index, (boolean)false), StringSplitter.m_92355_((String)string, (int)1, (int)index, (boolean)false));
    }

    protected void changeLine(int yChange) {
        int cursorPos = this.textFieldHelper.m_95194_();
        int line = this.getDisplayCache().changeLine(cursorPos, yChange);
        this.textFieldHelper.m_95179_(line, Screen.m_96638_());
    }

    protected void keyHome() {
        if (Screen.m_96637_()) {
            this.textFieldHelper.m_95176_(Screen.m_96638_());
        } else {
            int cursorIndex = this.textFieldHelper.m_95194_();
            int lineStartIndex = this.getDisplayCache().findLineStart(cursorIndex);
            this.textFieldHelper.m_95179_(lineStartIndex, Screen.m_96638_());
        }
    }

    protected void keyEnd() {
        if (Screen.m_96637_()) {
            this.textFieldHelper.m_95186_(Screen.m_96638_());
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            int cursorIndex = this.textFieldHelper.m_95194_();
            int lineEndIndex = displayCache.findLineEnd(cursorIndex);
            this.textFieldHelper.m_95179_(lineEndIndex, Screen.m_96638_());
        }
    }
}

