/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.integration.jade.component_provider;

import io.github.mortuusars.exposure.block.entity.Lightroom;
import io.github.mortuusars.exposure.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.integration.jade.ExposureJadePlugin;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.ui.ProgressArrowElement;

public enum LightroomComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>,
IServerExtensionProvider<LightroomBlockEntity, ItemStack>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        ItemStack paper;
        CompoundTag tag = blockAccessor.getServerData();
        if (tag.m_128471_("Empty")) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        tooltip.add(helper.spacer(0, 0));
        ItemStack film = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Film"));
        if (!film.m_41619_()) {
            tooltip.append(helper.item(film));
            tooltip.append(helper.text((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY)).size(new Vec2(11.0f, 12.0f)).translate(new Vec2(5.0f, 6.0f)).message(null));
        }
        if (!(paper = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Paper"))).m_41619_()) {
            tooltip.append(helper.item(paper));
            tooltip.append(helper.text((Component)Component.m_237113_((String)"+").m_130940_(ChatFormatting.GRAY)).size(new Vec2(12.0f, 12.0f)).translate(new Vec2(5.0f, 6.0f)).message(null));
        }
        for (String dye : new String[]{"Cyan", "Yellow", "Magenta", "Black"}) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(dye));
            if (stack.m_41619_()) continue;
            tooltip.append(helper.item(stack));
        }
        tooltip.append((IElement)new ProgressArrowElement(tag.m_128457_("Progress")));
        tooltip.append(helper.item(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Result"))));
        Lightroom.Process process = Lightroom.Process.fromStringOrDefault(tag.m_128461_("Process"), Lightroom.Process.REGULAR);
        if (process != Lightroom.Process.REGULAR) {
            tooltip.add(helper.text((Component)Component.m_237115_((String)("gui.exposure.lightroom.process." + process.m_7912_()))));
        }
        tooltip.add(helper.spacer(0, 2));
    }

    public void appendServerData(CompoundTag tag, ServerPlayer serverPlayer, Level level, BlockEntity be, boolean b) {
        if (be instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)be;
            if (lightroomBlockEntity.m_7983_()) {
                tag.m_128379_("Empty", true);
                return;
            }
            tag.m_128365_("Film", (Tag)lightroomBlockEntity.m_8020_(0).m_41739_(new CompoundTag()));
            tag.m_128365_("Paper", (Tag)lightroomBlockEntity.m_8020_(1).m_41739_(new CompoundTag()));
            tag.m_128365_("Cyan", (Tag)lightroomBlockEntity.m_8020_(2).m_41739_(new CompoundTag()));
            tag.m_128365_("Yellow", (Tag)lightroomBlockEntity.m_8020_(4).m_41739_(new CompoundTag()));
            tag.m_128365_("Magenta", (Tag)lightroomBlockEntity.m_8020_(3).m_41739_(new CompoundTag()));
            tag.m_128365_("Black", (Tag)lightroomBlockEntity.m_8020_(5).m_41739_(new CompoundTag()));
            tag.m_128365_("Result", (Tag)lightroomBlockEntity.m_8020_(6).m_41739_(new CompoundTag()));
            tag.m_128359_("Process", lightroomBlockEntity.getProcess().m_7912_());
            tag.m_128350_("Progress", lightroomBlockEntity.getProgressPercentage());
        }
    }

    public ResourceLocation getUid() {
        return ExposureJadePlugin.LIGHTROOM;
    }

    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(ServerPlayer serverPlayer, ServerLevel serverLevel, LightroomBlockEntity lightroomBlockEntity, boolean b) {
        return null;
    }
}

