/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class AlbumPage {
    public static final String PHOTOGRAPH_TAG = "Photo";
    public static final String NOTE_TAG = "Note";
    public static final String NOTE_COMPONENT_TAG = "NoteComponent";
    private ItemStack photographStack;
    private Either<String, Component> note;

    public AlbumPage(ItemStack photographStack, Either<String, Component> note) {
        this.photographStack = photographStack;
        this.note = note;
    }

    public static AlbumPage editable(ItemStack photographStack, String note) {
        return new AlbumPage(photographStack, (Either<String, Component>)Either.left((Object)note));
    }

    public static AlbumPage signed(ItemStack photographStack, Component note) {
        return new AlbumPage(photographStack, (Either<String, Component>)Either.right((Object)note));
    }

    public boolean isEditable() {
        return this.note.left().isPresent();
    }

    public boolean isEmpty() {
        return this.photographStack.m_41619_() && (Boolean)this.note.map(String::isEmpty, c -> c.getString().isEmpty()) != false;
    }

    public static AlbumPage fromTag(CompoundTag tag, boolean editable) {
        ItemStack photographStack;
        ItemStack itemStack = photographStack = tag.m_128425_(PHOTOGRAPH_TAG, 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(PHOTOGRAPH_TAG)) : ItemStack.f_41583_;
        if (editable) {
            MutableComponent component;
            String note = tag.m_128425_(NOTE_TAG, 8) ? tag.m_128461_(NOTE_TAG) : (tag.m_128441_(NOTE_COMPONENT_TAG) ? ((component = Component.Serializer.m_130701_((String)tag.m_128461_(NOTE_COMPONENT_TAG))) != null ? component.m_130668_(512) : "") : "");
            return AlbumPage.editable(photographStack, note);
        }
        MutableComponent note = tag.m_128425_(NOTE_COMPONENT_TAG, 8) ? Component.Serializer.m_130701_((String)tag.m_128461_(NOTE_COMPONENT_TAG)) : (tag.m_128441_(NOTE_TAG) ? Component.m_237113_((String)tag.m_128461_(NOTE_TAG)) : Component.m_237119_());
        return AlbumPage.signed(photographStack, (Component)note);
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (!this.photographStack.m_41619_()) {
            tag.m_128365_(PHOTOGRAPH_TAG, (Tag)this.photographStack.m_41739_(new CompoundTag()));
        }
        this.note.ifLeft(string -> {
            if (!string.isEmpty()) {
                tag.m_128359_(NOTE_TAG, string);
            }
        }).ifRight(component -> tag.m_128359_(NOTE_COMPONENT_TAG, Component.Serializer.m_130703_((Component)component)));
        return tag;
    }

    public ItemStack getPhotographStack() {
        return this.photographStack;
    }

    public ItemStack setPhotographStack(ItemStack photographStack) {
        ItemStack existingStack = this.photographStack;
        this.photographStack = photographStack;
        return existingStack;
    }

    public Either<String, Component> getNote() {
        return this.note;
    }

    public void setNote(Either<String, Component> note) {
        this.note = note;
    }

    public AlbumPage toSigned() {
        if (!this.isEditable()) {
            return this;
        }
        MutableComponent noteComponent = Component.m_237113_((String)((String)this.getNote().left().orElseThrow()));
        return AlbumPage.signed(this.getPhotographStack(), (Component)noteComponent);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AlbumPage that = (AlbumPage)obj;
        return Objects.equals(this.photographStack, that.photographStack) && Objects.equals(this.note, that.note);
    }

    public int hashCode() {
        return Objects.hash(this.photographStack, this.note);
    }

    public String toString() {
        return "Page[photo=" + this.photographStack + ", note=" + this.note + "]";
    }
}

