/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.block.FlashBlock;
import io.github.mortuusars.exposure.camera.AttachmentSound;
import io.github.mortuusars.exposure.camera.AttachmentType;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.CaptureManager;
import io.github.mortuusars.exposure.camera.capture.component.BaseComponent;
import io.github.mortuusars.exposure.camera.capture.component.BlackAndWhiteComponent;
import io.github.mortuusars.exposure.camera.capture.component.BrightnessComponent;
import io.github.mortuusars.exposure.camera.capture.component.ExposureStorageSaveComponent;
import io.github.mortuusars.exposure.camera.capture.component.FlashComponent;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.camera.capture.component.SelectiveChannelBlackAndWhiteComponent;
import io.github.mortuusars.exposure.camera.capture.converter.DitheringColorConverter;
import io.github.mortuusars.exposure.camera.infrastructure.CompositionGuide;
import io.github.mortuusars.exposure.camera.infrastructure.CompositionGuides;
import io.github.mortuusars.exposure.camera.infrastructure.EntitiesInFrame;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.camera.infrastructure.FlashMode;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.camera.infrastructure.ShutterSpeed;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.item.CameraItemClientExtensions;
import io.github.mortuusars.exposure.item.FilmRollItem;
import io.github.mortuusars.exposure.item.IFilmItem;
import io.github.mortuusars.exposure.menu.CameraAttachmentsMenu;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.OnFrameAddedS2CP;
import io.github.mortuusars.exposure.network.packet.client.StartExposureS2CP;
import io.github.mortuusars.exposure.network.packet.server.CameraInHandAddFrameC2SP;
import io.github.mortuusars.exposure.network.packet.server.OpenCameraAttachmentsPacketC2SP;
import io.github.mortuusars.exposure.sound.OnePerPlayerSounds;
import io.github.mortuusars.exposure.sound.OnePerPlayerSoundsClient;
import io.github.mortuusars.exposure.util.CameraInHand;
import io.github.mortuusars.exposure.util.ColorChannel;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.LevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.KnowledgeBookItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraItem
extends Item {
    public static final AttachmentType FILM_ATTACHMENT = new AttachmentType("Film", 0, stack -> stack.m_41720_() instanceof FilmRollItem, AttachmentSound.FILM);
    public static final AttachmentType FLASH_ATTACHMENT = new AttachmentType("Flash", 1, stack -> stack.m_204117_(Exposure.Tags.Items.FLASHES), AttachmentSound.FLASH);
    public static final AttachmentType LENS_ATTACHMENT = new AttachmentType("Lens", 2, stack -> stack.m_204117_(Exposure.Tags.Items.LENSES), AttachmentSound.LENS);
    public static final AttachmentType FILTER_ATTACHMENT = new AttachmentType("Filter", 3, stack -> stack.m_204117_(Exposure.Tags.Items.FILTERS), AttachmentSound.FILTER);
    public static final List<AttachmentType> ATTACHMENTS = List.of(FILM_ATTACHMENT, FLASH_ATTACHMENT, LENS_ATTACHMENT, FILTER_ATTACHMENT);
    public static final List<ShutterSpeed> SHUTTER_SPEEDS = List.of(new ShutterSpeed("15\""), new ShutterSpeed("8\""), new ShutterSpeed("4\""), new ShutterSpeed("2\""), new ShutterSpeed("1\""), new ShutterSpeed("2"), new ShutterSpeed("4"), new ShutterSpeed("8"), new ShutterSpeed("15"), new ShutterSpeed("30"), new ShutterSpeed("60"), new ShutterSpeed("125"), new ShutterSpeed("250"), new ShutterSpeed("500"));

    public CameraItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 1000;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        if (!((Boolean)Config.Client.CAMERA_SHOW_FILM_BAR_ON_ITEM.get()).booleanValue()) {
            return false;
        }
        return this.getAttachment(stack, FILM_ATTACHMENT).map(f -> {
            FilmRollItem filmRollItem;
            Item patt5762$temp = f.m_41720_();
            return patt5762$temp instanceof FilmRollItem && (filmRollItem = (FilmRollItem)patt5762$temp).m_142522_((ItemStack)f);
        }).orElse(false);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        if (!((Boolean)Config.Client.CAMERA_SHOW_FILM_BAR_ON_ITEM.get()).booleanValue()) {
            return 0;
        }
        return this.getAttachment(stack, FILM_ATTACHMENT).map(f -> {
            Integer n;
            Item patt6110$temp = f.m_41720_();
            if (patt6110$temp instanceof FilmRollItem) {
                FilmRollItem filmRollItem = (FilmRollItem)patt6110$temp;
                n = filmRollItem.m_142158_((ItemStack)f);
            } else {
                n = 0;
            }
            return n;
        }).orElse(0);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        if (!((Boolean)Config.Client.CAMERA_SHOW_FILM_BAR_ON_ITEM.get()).booleanValue()) {
            return 0;
        }
        return this.getAttachment(stack, FILM_ATTACHMENT).map(f -> {
            Integer n;
            Item patt6456$temp = f.m_41720_();
            if (patt6456$temp instanceof FilmRollItem) {
                FilmRollItem filmRollItem = (FilmRollItem)patt6456$temp;
                n = filmRollItem.m_142159_((ItemStack)f);
            } else {
                n = 0;
            }
            return n;
        }).orElse(0);
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (otherStack.m_41619_() && ((Boolean)Config.Common.CAMERA_GUI_RIGHT_CLICK_ATTACHMENTS_SCREEN.get()).booleanValue()) {
            if (!(slot.f_40218_ instanceof Inventory)) {
                return false;
            }
            if (player.m_7500_() && player.m_9236_().m_5776_()) {
                Packets.sendToServer(new OpenCameraAttachmentsPacketC2SP(slot.m_150661_()));
                return true;
            }
            this.openCameraAttachmentsMenu(player, slot.m_150661_());
            return true;
        }
        if (PlatformHelper.canShear(otherStack) && !this.isTooltipRemoved(stack)) {
            if (otherStack.m_41763_()) {
                otherStack.m_41622_(1, (LivingEntity)player, pl -> pl.m_21190_(InteractionHand.MAIN_HAND));
            }
            if (player.m_9236_().f_46443_) {
                player.m_216990_(SoundEvents.f_12344_);
            }
            this.setTooltipRemoved(stack, true);
            return true;
        }
        if (this.isTooltipRemoved(stack) && (otherStack.m_41720_() instanceof BookItem || otherStack.m_41720_() instanceof WritableBookItem || otherStack.m_41720_() instanceof WrittenBookItem || otherStack.m_41720_() instanceof KnowledgeBookItem)) {
            this.setTooltipRemoved(stack, false);
            if (player.m_9236_().f_46443_) {
                player.m_216990_(SoundEvents.f_12493_);
            }
            return true;
        }
        if (((Boolean)Config.Common.CAMERA_GUI_RIGHT_CLICK_HOTSWAP.get()).booleanValue()) {
            for (AttachmentType attachmentType : this.getAttachmentTypes(stack)) {
                if (!attachmentType.matches(otherStack)) continue;
                Optional<ItemStack> current = this.getAttachment(stack, attachmentType);
                if (otherStack.m_41613_() > 1 && current.isPresent()) {
                    if (player.m_9236_().m_5776_()) {
                        OnePerPlayerSoundsClient.play(player, Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), SoundSource.PLAYERS, 0.9f, 1.0f);
                    }
                    return true;
                }
                this.setAttachment(stack, attachmentType, otherStack.m_41620_(1));
                access.m_142104_(current.orElse(otherStack));
                attachmentType.sound().playOnePerPlayer(player, false);
                return true;
            }
        }
        return false;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag isAdvanced) {
        if (((Boolean)Config.Client.CAMERA_SHOW_FILM_FRAMES_IN_TOOLTIP.get()).booleanValue()) {
            this.getAttachment(stack, FILM_ATTACHMENT).ifPresent(f -> {
                Item patt9991$temp = f.m_41720_();
                if (patt9991$temp instanceof FilmRollItem) {
                    FilmRollItem filmRollItem = (FilmRollItem)patt9991$temp;
                    int exposed = filmRollItem.getExposedFramesCount((ItemStack)f);
                    int max = filmRollItem.getMaxFrameCount((ItemStack)f);
                    components.add((Component)Component.m_237110_((String)"item.exposure.camera.tooltip.film_roll_frames", (Object[])new Object[]{exposed, max}));
                }
            });
        }
        if (!this.isTooltipRemoved(stack) && ((Boolean)Config.Client.CAMERA_SHOW_TOOLTIP_DETAILS.get()).booleanValue()) {
            boolean rClickAttachments = (Boolean)Config.Common.CAMERA_GUI_RIGHT_CLICK_ATTACHMENTS_SCREEN.get();
            boolean rClickHotswap = (Boolean)Config.Common.CAMERA_GUI_RIGHT_CLICK_HOTSWAP.get();
            if (rClickAttachments || rClickHotswap) {
                if (Screen.m_96638_()) {
                    if (rClickAttachments) {
                        components.add((Component)Component.m_237115_((String)"item.exposure.camera.tooltip.details_attachments_screen"));
                    }
                    if (rClickHotswap) {
                        components.add((Component)Component.m_237115_((String)"item.exposure.camera.tooltip.details_hotswap"));
                    }
                    components.add((Component)Component.m_237115_((String)"item.exposure.camera.tooltip.details_remove_tooltip"));
                } else {
                    components.add((Component)Component.m_237115_((String)"tooltip.exposure.hold_for_details"));
                }
            }
        }
    }

    public boolean isActive(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("Active");
    }

    public void setActive(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_("Active", active);
        this.setSelfieMode(stack, false);
    }

    public void activate(Player player, ItemStack stack) {
        if (!this.isActive(stack)) {
            this.setActive(stack, true);
            player.m_146850_(GameEvent.f_157811_);
            this.playCameraSound(player, Exposure.SoundEvents.VIEWFINDER_OPEN.get(), 0.35f, 0.9f, 0.2f);
        }
    }

    public void deactivate(Player player, ItemStack stack) {
        if (this.isActive(stack)) {
            this.setActive(stack, false);
            player.m_146850_(GameEvent.f_157811_);
            this.playCameraSound(player, Exposure.SoundEvents.VIEWFINDER_CLOSE.get(), 0.35f, 0.9f, 0.2f);
        }
    }

    public boolean isInSelfieMode(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("Selfie");
    }

    public void setSelfieMode(ItemStack stack, boolean selfie) {
        stack.m_41784_().m_128379_("Selfie", selfie);
    }

    public boolean isTooltipRemoved(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("TooltipRemoved");
    }

    public void setTooltipRemoved(ItemStack stack, boolean removed) {
        stack.m_41784_().m_128379_("TooltipRemoved", removed);
    }

    public void setSelfieModeWithEffects(Player player, ItemStack stack, boolean selfie) {
        this.setSelfieMode(stack, selfie);
        player.m_9236_().m_6269_(player, (Entity)player, Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), SoundSource.PLAYERS, 1.0f, 1.5f);
    }

    public boolean isShutterOpen(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("ShutterOpen");
    }

    public void setShutterOpen(Level level, ItemStack stack, ShutterSpeed shutterSpeed, boolean exposingFrame, boolean flashHasFired) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("ShutterOpen", true);
        tag.m_128405_("ShutterTicks", Math.max(shutterSpeed.getTicks(), 1));
        tag.m_128356_("ShutterCloseTimestamp", level.m_46467_() + (long)Math.max(shutterSpeed.getTicks(), 1));
        if (exposingFrame) {
            tag.m_128379_("ExposingFrame", true);
        }
        if (flashHasFired) {
            tag.m_128379_("FlashHasFired", true);
        }
    }

    public void setShutterClosed(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_("ShutterOpen");
            tag.m_128473_("ShutterTicks");
            tag.m_128473_("ShutterCloseTimestamp");
            tag.m_128473_("ExposingFrame");
            tag.m_128473_("FlashHasFired");
        }
    }

    public void openShutter(Player player, ItemStack stack, ShutterSpeed shutterSpeed, boolean exposingFrame, boolean flashHasFired) {
        this.setShutterOpen(player.m_9236_(), stack, shutterSpeed, exposingFrame, flashHasFired);
        player.m_146850_(GameEvent.f_223697_);
        this.playCameraSound(null, player, Exposure.SoundEvents.SHUTTER_OPEN.get(), exposingFrame ? 0.7f : 0.5f, exposingFrame ? 1.1f : 1.25f, 0.2f);
        if (shutterSpeed.getMilliseconds() > 500.0f) {
            OnePerPlayerSounds.playForAllClients(player, Exposure.SoundEvents.SHUTTER_TICKING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void closeShutter(Player player, ItemStack stack) {
        long closedAtTimestamp = stack.m_41783_() != null ? stack.m_41783_().m_128454_("ShutterCloseTimestamp") : -1L;
        boolean exposingFrame = stack.m_41783_() != null && stack.m_41783_().m_128471_("ExposingFrame");
        boolean flashHasFired = stack.m_41783_() != null && stack.m_41783_().m_128471_("FlashHasFired");
        this.setShutterClosed(stack);
        if (player.m_9236_().m_46467_() - closedAtTimestamp < 60L) {
            player.m_146850_(GameEvent.f_223697_);
            player.m_36335_().m_41524_((Item)this, flashHasFired ? 10 : 2);
            this.playCameraSound(player, player, Exposure.SoundEvents.SHUTTER_CLOSE.get(), 0.7f, 1.1f, 0.2f);
            if (exposingFrame) {
                boolean lastFrame;
                ItemAndStack<FilmRollItem> film = this.getFilm(stack).orElseThrow();
                float fullness = (float)film.getItem().getExposedFramesCount(film.getStack()) / (float)film.getItem().getMaxFrameCount(film.getStack());
                boolean bl = lastFrame = fullness == 1.0f;
                if (lastFrame) {
                    OnePerPlayerSounds.play(player, Exposure.SoundEvents.FILM_ADVANCE_LAST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    OnePerPlayerSounds.play(player, Exposure.SoundEvents.FILM_ADVANCING.get(), SoundSource.PLAYERS, 1.0f, 0.9f + 0.1f * fullness);
                }
            }
        }
    }

    public void playCameraSound(@NotNull Player player, SoundEvent sound, float volume, float pitch) {
        this.playCameraSound(player, sound, volume, pitch, 0.0f);
    }

    public void playCameraSound(@NotNull Player player, SoundEvent sound, float volume, float pitch, float pitchVariety) {
        this.playCameraSound(player, player, sound, volume, pitch, pitchVariety);
    }

    public void playCameraSound(@Nullable Player player, @NotNull Player originPlayer, SoundEvent sound, float volume, float pitch, float pitchVariety) {
        if (pitchVariety > 0.0f) {
            pitch = pitch - pitchVariety / 2.0f + originPlayer.m_217043_().m_188501_() * pitchVariety;
        }
        originPlayer.m_9236_().m_6269_(player, (Entity)originPlayer, sound, SoundSource.PLAYERS, volume, pitch);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        boolean inHand;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isShutterOpen(stack)) {
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("ShutterTicks")) {
                int ticks = stack.m_41783_().m_128451_("ShutterTicks");
                if (ticks <= 0) {
                    this.closeShutter(player, stack);
                } else {
                    stack.m_41783_().m_128405_("ShutterTicks", --ticks);
                }
            } else {
                this.closeShutter(player, stack);
            }
        }
        boolean inOffhand = player.m_21206_().equals(stack);
        boolean bl = inHand = isSelected || inOffhand;
        if (!inHand) {
            this.deactivate(player, stack);
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            InteractionHand hand = context.m_43724_();
            if (hand == InteractionHand.MAIN_HAND && CameraInHand.getActiveHand(player) == InteractionHand.OFF_HAND) {
                return InteractionResult.PASS;
            }
            return this.useCamera(player, hand);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && CameraInHand.getActiveHand(player) == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        this.useCamera(player, hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public InteractionResult useCamera(Player player, InteractionHand hand) {
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResult.FAIL;
        }
        ItemStack cameraStack = player.m_21120_(hand);
        if (cameraStack.m_41619_() || cameraStack.m_41720_() != this) {
            return InteractionResult.PASS;
        }
        boolean active = this.isActive(cameraStack);
        if (!active && player.m_36341_()) {
            if (this.isShutterOpen(cameraStack)) {
                player.m_5661_((Component)Component.m_237115_((String)"item.exposure.camera.camera_attachments.fail.shutter_open").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            int cameraSlot = this.getMatchingSlotInInventory(player.m_150109_(), cameraStack);
            if (cameraSlot < 0) {
                return InteractionResult.FAIL;
            }
            this.openCameraAttachmentsMenu(player, cameraSlot);
            return InteractionResult.SUCCESS;
        }
        if (!active) {
            this.activate(player, cameraStack);
            player.m_36335_().m_41524_((Item)this, 4);
            if (player.m_9236_().f_46443_) {
                CameraItemClientExtensions.releaseUseButton();
            }
            return InteractionResult.CONSUME;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.CONSUME;
        }
        this.playCameraSound(null, player, Exposure.SoundEvents.CAMERA_RELEASE_BUTTON_CLICK.get(), 0.3f, 1.0f, 0.1f);
        Optional<ItemAndStack<FilmRollItem>> filmAttachment = this.getFilm(cameraStack);
        if (filmAttachment.isEmpty()) {
            return InteractionResult.FAIL;
        }
        ItemAndStack<FilmRollItem> film = filmAttachment.get();
        boolean exposingFilm = film.getItem().canAddFrame(film.getStack());
        if (!exposingFilm) {
            return InteractionResult.FAIL;
        }
        if (this.isShutterOpen(cameraStack)) {
            return InteractionResult.FAIL;
        }
        int lightLevel = LevelUtil.getLightLevelAt(player.m_9236_(), player.m_20183_());
        boolean shouldFlashFire = this.shouldFlashFire(player, cameraStack);
        ShutterSpeed shutterSpeed = this.getShutterSpeed(cameraStack);
        if (PlatformHelper.fireShutterOpeningEvent(player, cameraStack, lightLevel, shouldFlashFire)) {
            return InteractionResult.FAIL;
        }
        boolean flashHasFired = shouldFlashFire && this.tryUseFlash(player, cameraStack);
        this.openShutter(player, cameraStack, shutterSpeed, true, flashHasFired);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Packets.sendToClient(new StartExposureS2CP(this.createExposureId(player), hand, flashHasFired, lightLevel), serverPlayer);
        }
        return InteractionResult.CONSUME;
    }

    public void exposeFrameClientside(Player player, InteractionHand hand, String exposureId, boolean flashHasFired, int lightLevel) {
        Preconditions.checkState((boolean)player.m_9236_().f_46443_, (Object)"Should only be called on client.");
        ItemStack cameraStack = player.m_21120_(hand);
        if (PlatformHelper.fireShutterOpeningEvent(player, cameraStack, lightLevel, flashHasFired)) {
            return;
        }
        CompoundTag frame = new CompoundTag();
        frame.m_128359_("Id", exposureId);
        frame.m_128359_("Timestamp", Util.m_241986_());
        frame.m_128359_("Photographer", player.m_6302_());
        frame.m_128362_("PhotographerId", player.m_20148_());
        frame.m_128405_("LightLevel", lightLevel);
        frame.m_128350_("SunAngle", player.m_9236_().m_46490_(0.0f));
        if (flashHasFired) {
            frame.m_128379_("Flash", true);
        }
        if (this.isInSelfieMode(cameraStack)) {
            frame.m_128379_("Selfie", true);
        }
        Capture capture = this.createCapture(player, cameraStack, exposureId, flashHasFired);
        CaptureManager.enqueue(capture);
        List<UUID> entities = EntitiesInFrame.get(player, ViewfinderClient.getCurrentFov(), 12, this.isInSelfieMode(cameraStack)).stream().map(Entity::m_20148_).toList();
        Packets.sendToServer(new CameraInHandAddFrameC2SP(hand, frame, entities));
    }

    public void addFrame(ServerPlayer player, ItemStack cameraStack, InteractionHand hand, CompoundTag frame, List<Entity> entities) {
        this.addFrameData(player, cameraStack, frame, entities);
        PlatformHelper.fireModifyFrameDataEvent(player, cameraStack, frame, entities);
        this.addFrameToFilm(cameraStack, frame);
        player.m_36220_(Exposure.Stats.FILM_FRAMES_EXPOSED);
        Exposure.Advancements.FILM_FRAME_EXPOSED.trigger(player, new ItemAndStack<CameraItem>(cameraStack), frame);
        Packets.sendToClient(new OnFrameAddedS2CP(frame), player);
        PlatformHelper.fireFrameAddedEvent(player, cameraStack, frame);
    }

    public void addFrameToFilm(ItemStack cameraStack, CompoundTag frame) {
        ItemAndStack<FilmRollItem> film = this.getFilm(cameraStack).orElseThrow(() -> new IllegalStateException("Camera should have film inserted. " + cameraStack));
        film.getItem().addFrame(film.getStack(), frame);
        this.setFilm(cameraStack, film.getStack());
    }

    protected boolean shouldFlashFire(Player player, ItemStack cameraStack) {
        if (this.getAttachment(cameraStack, FLASH_ATTACHMENT).isEmpty()) {
            return false;
        }
        return switch (this.getFlashMode(cameraStack)) {
            default -> throw new IncompatibleClassChangeError();
            case FlashMode.OFF -> false;
            case FlashMode.ON -> true;
            case FlashMode.AUTO -> LevelUtil.getLightLevelAt(player.m_9236_(), player.m_20183_()) < 8;
        };
    }

    public boolean tryUseFlash(Player player, ItemStack cameraStack) {
        Level level = player.m_9236_();
        BlockPos playerHeadPos = player.m_20183_().m_7494_();
        BlockPos flashPos = null;
        if (level.m_8055_(playerHeadPos).m_60795_() || level.m_6425_(playerHeadPos).m_164512_((Fluid)Fluids.f_76193_)) {
            flashPos = playerHeadPos;
        } else {
            for (Direction direction : Direction.values()) {
                BlockPos pos = playerHeadPos.m_121945_(direction);
                if (!level.m_8055_(pos).m_60795_() && !level.m_6425_(pos).m_164512_((Fluid)Fluids.f_76193_)) continue;
                flashPos = pos;
            }
        }
        if (flashPos == null) {
            return false;
        }
        level.m_7731_(flashPos, (BlockState)Exposure.Blocks.FLASH.get().m_49966_().m_61124_((Property)FlashBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(flashPos).m_164512_((Fluid)Fluids.f_76193_))), 11);
        level.m_6269_(player, (Entity)player, Exposure.SoundEvents.FLASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_146850_(GameEvent.f_157776_);
        player.m_36220_(Exposure.Stats.FLASHES_TRIGGERED);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Vec3 pos = player.m_20182_();
                pos = pos.m_82520_(0.0, 1.0, 0.0).m_82549_(player.m_20154_().m_82542_(0.5, 0.0, 0.5));
                ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123747_, false, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0f, 0.0f, 0.0f, 0.0f, 0);
                for (ServerPlayer pl : serverLevel.m_6907_()) {
                    if (pl.equals((Object)serverPlayer)) continue;
                    pl.f_8906_.m_9829_((Packet)packet);
                    RandomSource r = serverLevel.m_213780_();
                    for (int i = 0; i < 4; ++i) {
                        pl.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123810_, false, pos.f_82479_ + (double)(r.m_188501_() * 0.5f) - 0.25, pos.f_82480_ + (double)(r.m_188501_() * 0.5f) + (double)0.2f, pos.f_82481_ + (double)(r.m_188501_() * 0.5f) - 0.25, 0.0f, 0.0f, 0.0f, 0.0f, 0));
                    }
                }
            }
        }
        return true;
    }

    public void addFrameData(ServerPlayer player, ItemStack cameraStack, CompoundTag frame, List<Entity> entitiesInFrame) {
        ServerLevel level = player.m_9236_();
        Boolean isBW = this.getAttachment(cameraStack, FILM_ATTACHMENT).map(f -> {
            IFilmItem filmItem;
            Item patt28086$temp = f.m_41720_();
            return patt28086$temp instanceof IFilmItem && (filmItem = (IFilmItem)patt28086$temp).getType() == FilmType.BLACK_AND_WHITE;
        }).orElse(false);
        if (isBW.booleanValue()) {
            this.getAttachment(cameraStack, FILTER_ATTACHMENT).flatMap(ColorChannel::fromStack).ifPresent(c -> {
                frame.m_128379_("Chromatic", true);
                frame.m_128359_("ChromaticChannel", c.m_7912_());
            });
        }
        ListTag pos = new ListTag();
        pos.add((Object)IntTag.m_128679_((int)player.m_20183_().m_123341_()));
        pos.add((Object)IntTag.m_128679_((int)player.m_20183_().m_123342_()));
        pos.add((Object)IntTag.m_128679_((int)player.m_20183_().m_123343_()));
        frame.m_128365_("Pos", (Tag)pos);
        frame.m_128359_("Dimension", player.m_9236_().m_46472_().m_135782_().toString());
        player.m_9236_().m_204166_(player.m_20183_()).m_203543_().map(ResourceKey::m_135782_).ifPresent(biome -> frame.m_128359_("Biome", biome.toString()));
        int surfaceHeight = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, player.m_146903_(), player.m_146907_());
        level.m_46465_();
        int skyLight = level.m_45517_(LightLayer.SKY, player.m_20183_());
        if (player.m_5842_()) {
            frame.m_128379_("Underwater", true);
        }
        if (player.m_146904_() < surfaceHeight && skyLight < 2) {
            frame.m_128379_("InCave", true);
        } else if (!player.m_5842_()) {
            Biome.Precipitation precipitation = ((Biome)level.m_204166_(player.m_20183_()).m_203334_()).m_47530_();
            if (level.m_46470_() && precipitation != Biome.Precipitation.NONE) {
                frame.m_128359_("Weather", precipitation == Biome.Precipitation.SNOW ? "Snowstorm" : "Thunder");
            } else if (level.m_46471_() && precipitation != Biome.Precipitation.NONE) {
                frame.m_128359_("Weather", precipitation == Biome.Precipitation.SNOW ? "Snow" : "Rain");
            } else {
                frame.m_128359_("Weather", "Clear");
            }
        }
        this.addStructuresInfo(player, frame);
        if (!entitiesInFrame.isEmpty()) {
            ListTag entities = new ListTag();
            for (Entity entity : entitiesInFrame) {
                CompoundTag entityInfoTag = this.createEntityInFrameTag(entity, (Player)player, cameraStack);
                if (entityInfoTag.m_128456_()) continue;
                entities.add((Object)entityInfoTag);
                frame.m_128379_(entityInfoTag.m_128461_("Id"), true);
            }
            if (!entities.isEmpty()) {
                frame.m_128365_("Entities", (Tag)entities);
            }
        }
    }

    protected void addStructuresInfo(@NotNull ServerPlayer player, CompoundTag frame) {
        Map allStructuresAt = player.m_9236_().m_215010_().m_220522_(player.m_20183_());
        ArrayList<Structure> inside = new ArrayList<Structure>();
        for (Structure structure : allStructuresAt.keySet()) {
            StructureStart structureAt = player.m_9236_().m_215010_().m_220494_(player.m_20183_(), structure);
            if (!structureAt.m_73603_()) continue;
            inside.add(structure);
        }
        Registry structures = player.m_9236_().m_5962_().m_175515_(BuiltinRegistries.f_235988_.m_123023_());
        ListTag structuresTag = new ListTag();
        for (Structure structure : inside) {
            ResourceLocation key = structures.m_7981_((Object)structure);
            if (key == null) continue;
            structuresTag.add((Object)StringTag.m_129297_((String)key.toString()));
        }
        if (!structuresTag.isEmpty()) {
            frame.m_128365_("Structures", (Tag)structuresTag);
        }
    }

    protected CompoundTag createEntityInFrameTag(Entity entity, Player photographer, ItemStack cameraStack) {
        CompoundTag tag = new CompoundTag();
        ResourceLocation entityRL = Registry.f_122826_.m_7981_((Object)entity.m_6095_());
        tag.m_128359_("Id", entityRL.toString());
        ListTag pos = new ListTag();
        pos.add((Object)IntTag.m_128679_((int)((int)entity.m_20185_())));
        pos.add((Object)IntTag.m_128679_((int)((int)entity.m_20186_())));
        pos.add((Object)IntTag.m_128679_((int)((int)entity.m_20189_())));
        tag.m_128365_("Pos", (Tag)pos);
        tag.m_128350_("Distance", photographer.m_20270_(entity));
        if (entity instanceof Player) {
            Player player = (Player)entity;
            tag.m_128359_("Name", player.m_6302_());
        }
        return tag;
    }

    public void openCameraAttachmentsMenu(Player player, final int cameraSlotIndex) {
        final ItemStack stack = player.m_150109_().m_8020_(cameraSlotIndex);
        Preconditions.checkState((boolean)(stack.m_41720_() instanceof CameraItem), (Object)("Cannot open Camera Attachments UI: " + stack + " is not a CameraItem."));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuProvider menuProvider = new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return stack.m_41788_() ? stack.m_41786_() : Component.m_237115_((String)"container.exposure.camera");
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                    return new CameraAttachmentsMenu(containerId, playerInventory, cameraSlotIndex);
                }
            };
            PlatformHelper.openMenu(serverPlayer, menuProvider, buffer -> buffer.writeInt(cameraSlotIndex));
        }
    }

    protected int getMatchingSlotInInventory(Inventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).equals(stack)) continue;
            return i;
        }
        return -1;
    }

    protected String createExposureId(Player player) {
        return player.m_7755_().getString() + "_" + player.m_9236_().m_46467_();
    }

    public FocalRange getFocalRange(ItemStack cameraStack) {
        return this.getAttachment(cameraStack, LENS_ATTACHMENT).map(FocalRange::ofStack).orElse(this.getDefaultFocalRange());
    }

    public FocalRange getDefaultFocalRange() {
        return FocalRange.getDefault();
    }

    protected Capture createCapture(Player player, ItemStack cameraStack, String exposureId, boolean flash) {
        ItemAndStack<FilmRollItem> film = this.getFilm(cameraStack).orElseThrow();
        int frameSize = film.getItem().getFrameSize(film.getStack());
        float brightnessStops = this.getShutterSpeed(cameraStack).getStopsDifference(ShutterSpeed.DEFAULT);
        ArrayList<ICaptureComponent> components = new ArrayList<ICaptureComponent>();
        components.add(new BaseComponent());
        if (flash) {
            components.add(new FlashComponent());
        }
        if (brightnessStops != 0.0f) {
            components.add(new BrightnessComponent(brightnessStops));
        }
        if (film.getItem().getType() == FilmType.BLACK_AND_WHITE) {
            Optional<ItemStack> filter = this.getAttachment(cameraStack, FILTER_ATTACHMENT);
            filter.flatMap(ColorChannel::fromStack).ifPresentOrElse(channel -> components.add(new SelectiveChannelBlackAndWhiteComponent((ColorChannel)((Object)channel))), () -> components.add(new BlackAndWhiteComponent()));
        }
        components.add(new ExposureStorageSaveComponent(exposureId, true));
        return new Capture().setFilmType(film.getItem().getType()).setSize(frameSize).setBrightnessStops(brightnessStops).addComponents(components).setConverter(new DitheringColorConverter());
    }

    public void spawnClientsideFlashEffects(@NotNull Player player, ItemStack cameraStack) {
        Preconditions.checkState((boolean)player.m_9236_().f_46443_, (Object)"This methods should only be called client-side.");
        Level level = player.m_9236_();
        Vec3 pos = player.m_20182_();
        Vec3 lookAngle = player.m_20154_();
        pos = pos.m_82520_(0.0, 1.0, 0.0).m_82549_(lookAngle.m_82542_((double)0.8f, (double)0.8f, (double)0.8f));
        RandomSource r = level.m_213780_();
        for (int i = 0; i < 3; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_ + (double)r.m_188501_() - 0.5, pos.f_82480_ + (double)r.m_188501_() + (double)0.15f, pos.f_82481_ + (double)r.m_188501_() - 0.5, lookAngle.f_82479_ * (double)0.025f + (double)(r.m_188501_() * 0.025f), lookAngle.f_82480_ * (double)0.025f + (double)(r.m_188501_() * 0.025f), lookAngle.f_82481_ * (double)0.025f + (double)(r.m_188501_() * 0.025f));
        }
    }

    public List<AttachmentType> getAttachmentTypes(ItemStack cameraStack) {
        return ATTACHMENTS;
    }

    public Optional<AttachmentType> getAttachmentTypeForSlot(ItemStack cameraStack, int slot) {
        List<AttachmentType> attachmentTypes = this.getAttachmentTypes(cameraStack);
        for (AttachmentType attachmentType : attachmentTypes) {
            if (attachmentType.slot() != slot) continue;
            return Optional.of(attachmentType);
        }
        return Optional.empty();
    }

    public Optional<ItemAndStack<FilmRollItem>> getFilm(ItemStack cameraStack) {
        return this.getAttachment(cameraStack, FILM_ATTACHMENT).map(ItemAndStack::new);
    }

    public void setFilm(ItemStack cameraStack, ItemStack filmStack) {
        this.setAttachment(cameraStack, FILM_ATTACHMENT, filmStack);
    }

    public Optional<ItemStack> getAttachment(ItemStack cameraStack, AttachmentType attachmentType) {
        ItemStack itemStack;
        if (cameraStack.m_41783_() != null && cameraStack.m_41783_().m_128425_(attachmentType.id(), 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)cameraStack.m_41783_().m_128469_(attachmentType.id()))).m_41619_()) {
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    public void setAttachment(ItemStack cameraStack, AttachmentType attachmentType, ItemStack attachmentStack) {
        if (attachmentStack.m_41619_()) {
            if (cameraStack.m_41783_() != null) {
                cameraStack.m_41784_().m_128473_(attachmentType.id());
            }
        } else {
            Preconditions.checkState((boolean)attachmentType.matches(attachmentStack), (Object)(attachmentStack + " is not valid for the '" + attachmentType + "' attachment type."));
            cameraStack.m_41784_().m_128365_(attachmentType.id(), (Tag)attachmentStack.m_41739_(new CompoundTag()));
        }
        if (attachmentType == LENS_ATTACHMENT) {
            this.setZoom(cameraStack, this.getFocalRange(cameraStack).min());
        }
    }

    public List<ShutterSpeed> getAllShutterSpeeds(ItemStack cameraStack) {
        return SHUTTER_SPEEDS;
    }

    public ShutterSpeed getShutterSpeed(ItemStack cameraStack) {
        return ShutterSpeed.loadOrDefault(cameraStack.m_41784_());
    }

    public void setShutterSpeed(ItemStack cameraStack, ShutterSpeed shutterSpeed) {
        shutterSpeed.save(cameraStack.m_41784_());
    }

    public float getFocalLength(ItemStack cameraStack) {
        return cameraStack.m_41782_() ? cameraStack.m_41784_().m_128457_("Zoom") : (float)this.getFocalRange(cameraStack).min();
    }

    public void setZoom(ItemStack cameraStack, double focalLength) {
        cameraStack.m_41784_().m_128347_("Zoom", focalLength);
    }

    public CompositionGuide getCompositionGuide(ItemStack cameraStack) {
        if (!cameraStack.m_41782_() || !cameraStack.m_41784_().m_128425_("CompositionGuide", 8)) {
            return CompositionGuides.NONE;
        }
        return CompositionGuides.byIdOrNone(cameraStack.m_41784_().m_128461_("CompositionGuide"));
    }

    public void setCompositionGuide(ItemStack cameraStack, CompositionGuide guide) {
        cameraStack.m_41784_().m_128359_("CompositionGuide", guide.getId());
    }

    public FlashMode getFlashMode(ItemStack cameraStack) {
        if (!cameraStack.m_41782_() || !cameraStack.m_41784_().m_128425_("FlashMode", 8)) {
            return FlashMode.OFF;
        }
        return FlashMode.byIdOrOff(cameraStack.m_41784_().m_128461_("FlashMode"));
    }

    public void setFlashMode(ItemStack cameraStack, FlashMode flashMode) {
        cameraStack.m_41784_().m_128359_("FlashMode", flashMode.getId());
    }
}

