/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.menu;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.AttachmentType;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.menu.FilteredSlot;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CameraAttachmentsMenu
extends AbstractContainerMenu {
    private final int attachmentSlotsCount;
    private final int cameraSlotIndex;
    private final Player player;
    private final ItemAndStack<CameraItem> camera;
    private boolean clientContentsInitialized;

    public CameraAttachmentsMenu(int containerId, Inventory playerInventory, int cameraSlotIndex) {
        super(Exposure.MenuTypes.CAMERA.get(), containerId);
        ItemStack cameraStack = (ItemStack)playerInventory.f_35974_.get(cameraSlotIndex);
        Preconditions.checkState((boolean)(cameraStack.m_41720_() instanceof CameraItem), (Object)("Failed to open Camera Attachments. " + cameraStack + " is not a CameraItem."));
        this.player = playerInventory.f_35978_;
        this.cameraSlotIndex = cameraSlotIndex;
        this.camera = new ItemAndStack(cameraStack);
        SimpleContainer container = new SimpleContainer((ItemStack[])CameraAttachmentsMenu.getCameraAttachments(this.camera).toArray(ItemStack[]::new)){

            public int m_6893_() {
                return 1;
            }
        };
        this.attachmentSlotsCount = this.addAttachmentSlots((Container)container);
        this.addPlayerSlots(playerInventory);
        if (this.player.m_9236_().f_46443_) {
            this.player.m_5496_(Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), 0.9f, 0.9f);
        }
    }

    public ItemAndStack<CameraItem> getCamera() {
        return this.camera;
    }

    public void m_182410_(int stateId, List<ItemStack> items, ItemStack carried) {
        this.clientContentsInitialized = false;
        super.m_182410_(stateId, items, carried);
        this.clientContentsInitialized = true;
    }

    protected int addAttachmentSlots(Container container) {
        int[][] slots;
        int attachmentSlots = 0;
        for (int[] slot : slots = new int[][]{{CameraItem.FILM_ATTACHMENT.slot(), 13, 42, 1}, {CameraItem.FLASH_ATTACHMENT.slot(), 147, 15, 1}, {CameraItem.LENS_ATTACHMENT.slot(), 147, 43, 1}, {CameraItem.FILTER_ATTACHMENT.slot(), 147, 71, 1}}) {
            Optional<AttachmentType> attachment = this.camera.getItem().getAttachmentTypeForSlot(this.camera.getStack(), slot[0]);
            if (!attachment.isPresent()) continue;
            this.m_38897_(new FilteredSlot(container, slot[0], slot[1], slot[2], slot[3], this::onItemInSlotChanged, attachment.get().itemPredicate()));
            ++attachmentSlots;
        }
        return attachmentSlots;
    }

    protected void addPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, column * 18 + 8, 103 + row * 18){

                    public boolean m_8010_(@NotNull Player player) {
                        return super.m_8010_(player) && this.m_150661_() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }

                    public boolean m_6659_() {
                        return this.m_150661_() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }

                    public boolean m_150651_(Player player) {
                        return this.m_150661_() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }
                });
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            int finalSlot = slot;
            this.m_38897_(new Slot((Container)playerInventory, finalSlot, slot * 18 + 8, 161){

                public boolean m_8010_(@NotNull Player player) {
                    return super.m_8010_(player) && this.m_150661_() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }

                public boolean m_6659_() {
                    return this.m_150661_() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }

                public boolean m_150651_(Player player) {
                    return this.m_150661_() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }
            });
        }
    }

    protected void onItemInSlotChanged(FilteredSlot.SlotChangedArgs args) {
        int slotId = args.slot().getSlotId();
        ItemStack newStack = args.newStack();
        this.camera.getItem().getAttachmentTypeForSlot(this.camera.getStack(), slotId).ifPresent(type -> {
            this.camera.getItem().setAttachment(this.camera.getStack(), (AttachmentType)type, newStack);
            if (this.player.m_9236_().m_5776_() && this.clientContentsInitialized) {
                type.sound().playOnePerPlayer(this.player, newStack.m_41619_());
            }
            if (!this.player.m_9236_().m_5776_() && this.player.m_7500_()) {
                this.player.m_150109_().m_6836_(this.cameraSlotIndex, this.camera.getStack());
            }
        });
    }

    private static NonNullList<ItemStack> getCameraAttachments(ItemAndStack<CameraItem> camera) {
        NonNullList items = NonNullList.m_122779_();
        List<AttachmentType> attachmentTypes = camera.getItem().getAttachmentTypes(camera.getStack());
        for (AttachmentType attachmentType : attachmentTypes) {
            items.add((Object)camera.getItem().getAttachment(camera.getStack(), attachmentType).orElse(ItemStack.f_41583_));
        }
        return items;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot clickedSlot = (Slot)this.f_38839_.get(slotIndex);
        if (clickedSlot.m_6657_()) {
            ItemStack slotStack = clickedSlot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (slotIndex < this.attachmentSlotsCount ? !this.m_38903_(slotStack, this.attachmentSlotsCount, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.attachmentSlotsCount, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                clickedSlot.m_5852_(ItemStack.f_41583_);
            } else {
                clickedSlot.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack movedStack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean hasRemainder = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (movedStack.m_41753_()) {
            while (!movedStack.m_41619_() && !(reverseDirection ? i < startIndex : i >= endIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack slotStack = slot.m_7993_();
                if (!slotStack.m_41619_() && ItemStack.m_150942_((ItemStack)movedStack, (ItemStack)slotStack)) {
                    int maxSize;
                    int j = slotStack.m_41613_() + movedStack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), movedStack.m_41741_()))) {
                        movedStack.m_41764_(0);
                        slotStack.m_41764_(j);
                        slot.m_6654_();
                        hasRemainder = true;
                    } else if (slotStack.m_41613_() < maxSize) {
                        movedStack.m_41774_(maxSize - slotStack.m_41613_());
                        slotStack.m_41764_(maxSize);
                        slot.m_6654_();
                        hasRemainder = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!movedStack.m_41619_()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(reverseDirection ? i < startIndex : i >= endIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack movedStack1 = slot1.m_7993_();
                if (movedStack1.m_41619_() && slot1.m_5857_(movedStack)) {
                    if (movedStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(movedStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(movedStack.m_41620_(movedStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    hasRemainder = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return hasRemainder;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        player.f_36095_.m_150444_();
    }

    public boolean m_6875_(@NotNull Player player) {
        boolean sameItemSameTags = ItemStack.m_150942_((ItemStack)player.m_150109_().m_8020_(this.cameraSlotIndex), (ItemStack)this.camera.getStack());
        return sameItemSameTags;
    }

    public static CameraAttachmentsMenu fromBuffer(int containerId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new CameraAttachmentsMenu(containerId, playerInventory, buffer.readInt());
    }
}

