/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.menu;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.block.entity.Lightroom;
import io.github.mortuusars.exposure.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.item.IFilmItem;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomMenu
extends AbstractContainerMenu {
    public static final int PRINT_BUTTON_ID = 0;
    public static final int PRINT_CREATIVE_BUTTON_ID = 1;
    public static final int PREVIOUS_FRAME_BUTTON_ID = 2;
    public static final int NEXT_FRAME_BUTTON_ID = 3;
    public static final int TOGGLE_PROCESS_BUTTON_ID = 4;
    private final LightroomBlockEntity lightroomBlockEntity;
    private final ContainerData data;
    private ListTag frames = new ListTag();

    public LightroomMenu(int containerId, final Inventory playerInventory, final LightroomBlockEntity blockEntity, ContainerData containerData) {
        super(Exposure.MenuTypes.LIGHTROOM.get(), containerId);
        this.lightroomBlockEntity = blockEntity;
        this.data = containerData;
        this.m_38897_(new Slot((Container)blockEntity, 0, -20, 42){

            public boolean m_5857_(ItemStack stack) {
                return blockEntity.isItemValidForSlot(0, stack);
            }

            public void m_6654_() {
                Item item = this.m_7993_().m_41720_();
                if (item instanceof DevelopedFilmItem) {
                    DevelopedFilmItem developedFilm = (DevelopedFilmItem)item;
                    v0 = developedFilm.getExposedFrames(this.m_7993_());
                } else {
                    v0 = LightroomMenu.this.frames = new ListTag();
                }
                if (LightroomMenu.this.lightroomBlockEntity.m_58904_() != null && !LightroomMenu.this.lightroomBlockEntity.m_58904_().f_46443_) {
                    LightroomMenu.this.data.m_8050_(2, 0);
                }
                super.m_6654_();
            }
        });
        this.m_38897_(new Slot((Container)blockEntity, 1, 8, 92){

            public boolean m_5857_(ItemStack stack) {
                return blockEntity.isItemValidForSlot(1, stack);
            }
        });
        this.m_38897_(new Slot((Container)blockEntity, 2, 42, 92){

            public boolean m_5857_(ItemStack stack) {
                return blockEntity.isItemValidForSlot(2, stack);
            }
        });
        this.m_38897_(new Slot((Container)blockEntity, 3, 60, 92){

            public boolean m_5857_(ItemStack stack) {
                return blockEntity.isItemValidForSlot(3, stack);
            }
        });
        this.m_38897_(new Slot((Container)blockEntity, 4, 78, 92){

            public boolean m_5857_(ItemStack stack) {
                return blockEntity.isItemValidForSlot(4, stack);
            }
        });
        this.m_38897_(new Slot((Container)blockEntity, 5, 96, 92){

            public boolean m_5857_(ItemStack stack) {
                return blockEntity.isItemValidForSlot(5, stack);
            }
        });
        this.m_38897_(new Slot((Container)blockEntity, 6, 148, 92){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public void m_142406_(@NotNull Player player, @NotNull ItemStack pStack) {
                super.m_142406_(player, pStack);
                blockEntity.dropStoredExperience(player);
            }

            public void m_40234_(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
                super.m_40234_(oldStackIn, newStackIn);
                blockEntity.dropStoredExperience(playerInventory.f_35978_);
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, column + row * 9 + 9, 8 + column * 18, 127 + row * 18));
            }
        }
        for (int index = 0; index < 9; ++index) {
            this.m_38897_(new Slot((Container)playerInventory, index, 8 + index * 18, 185));
        }
        this.m_38884_(this.data);
    }

    public static LightroomMenu fromBuffer(int containerID, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new LightroomMenu(containerID, playerInventory, LightroomMenu.getBlockEntity(playerInventory, buffer), (ContainerData)new SimpleContainerData(3));
    }

    public LightroomBlockEntity getBlockEntity() {
        return this.lightroomBlockEntity;
    }

    public ContainerData getData() {
        return this.data;
    }

    public ListTag getExposedFrames() {
        return this.frames;
    }

    @Nullable
    public CompoundTag getFrameIdByIndex(int index) {
        return index >= 0 && index < this.getExposedFrames().size() ? this.getExposedFrames().m_128728_(index) : null;
    }

    public int getSelectedFrame() {
        return this.data.m_6413_(2);
    }

    public boolean isPrinting() {
        return this.data.m_6413_(1) > 0;
    }

    public int getTotalFrames() {
        int n;
        Item item;
        ItemStack filmStack = this.getBlockEntity().m_8020_(0);
        if (!filmStack.m_41619_() && (item = filmStack.m_41720_()) instanceof IFilmItem) {
            IFilmItem filmItem = (IFilmItem)item;
            n = filmItem.getExposedFramesCount(filmStack);
        } else {
            n = 0;
        }
        return n;
    }

    public boolean m_6366_(Player player, int buttonId) {
        ItemStack filmStack;
        Preconditions.checkState((!player.m_9236_().f_46443_ ? 1 : 0) != 0, (Object)"This should be server-side only.");
        if ((buttonId == 2 || buttonId == 3) && !(filmStack = this.getBlockEntity().m_8020_(0)).m_41619_() && filmStack.m_41720_() instanceof DevelopedFilmItem) {
            int frames = this.getTotalFrames();
            if (frames == 0) {
                return true;
            }
            int selectedFrame = this.data.m_6413_(2);
            selectedFrame += buttonId == 3 ? 1 : -1;
            selectedFrame = Mth.m_14045_((int)selectedFrame, (int)0, (int)(frames - 1));
            this.data.m_8050_(2, selectedFrame);
            return true;
        }
        if (buttonId == 4) {
            Lightroom.Process currentProcess = this.getBlockEntity().getProcess();
            this.getBlockEntity().setProcess(currentProcess == Lightroom.Process.CHROMATIC ? Lightroom.Process.REGULAR : Lightroom.Process.CHROMATIC);
        }
        if (buttonId == 0) {
            this.getBlockEntity().startPrintingProcess(false);
            return true;
        }
        if (buttonId == 1 && player.m_7500_()) {
            this.getBlockEntity().printInCreativeMode();
        }
        return false;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        ItemStack clickedStack = slot.m_7993_();
        ItemStack returnedStack = clickedStack.m_41777_();
        if (index < 7) {
            if (!this.m_38903_(clickedStack, 7, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            if (index == 6) {
                slot.m_40234_(clickedStack, returnedStack);
            }
        } else if (index < this.f_38839_.size() && !this.m_38903_(clickedStack, 0, 7, false)) {
            return ItemStack.f_41583_;
        }
        if (clickedStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return returnedStack;
    }

    protected boolean m_38903_(ItemStack movedStack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean hasRemainder = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (movedStack.m_41753_()) {
            while (!movedStack.m_41619_() && !(reverseDirection ? i < startIndex : i >= endIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack slotStack = slot.m_7993_();
                if (!slotStack.m_41619_() && ItemStack.m_150942_((ItemStack)movedStack, (ItemStack)slotStack)) {
                    int maxSize;
                    int j = slotStack.m_41613_() + movedStack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), movedStack.m_41741_()))) {
                        movedStack.m_41764_(0);
                        slotStack.m_41764_(j);
                        slot.m_6654_();
                        hasRemainder = true;
                    } else if (slotStack.m_41613_() < maxSize) {
                        movedStack.m_41774_(maxSize - slotStack.m_41613_());
                        slotStack.m_41764_(maxSize);
                        slot.m_6654_();
                        hasRemainder = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!movedStack.m_41619_()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(reverseDirection ? i < startIndex : i >= endIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemmovedStack1 = slot1.m_7993_();
                if (itemmovedStack1.m_41619_() && slot1.m_5857_(movedStack)) {
                    if (movedStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(movedStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(movedStack.m_41620_(movedStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    hasRemainder = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return hasRemainder;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.lightroomBlockEntity.m_6542_(player);
    }

    private static LightroomBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntityAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntityAtPos instanceof LightroomBlockEntity) {
            LightroomBlockEntity blockEntity = (LightroomBlockEntity)blockEntityAtPos;
            return blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + blockEntityAtPos);
    }
}

