/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record CameraInHandAddFrameC2SP(InteractionHand hand, CompoundTag frame, List<UUID> entitiesInFrameIds) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("camera_in_hand_add_frame");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.hand);
        buffer.m_130079_(this.frame);
        buffer.writeInt(this.entitiesInFrameIds.size());
        for (UUID uuid : this.entitiesInFrameIds) {
            buffer.m_130077_(uuid);
        }
        return buffer;
    }

    public static CameraInHandAddFrameC2SP fromBuffer(FriendlyByteBuf buffer) {
        InteractionHand hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        @Nullable CompoundTag frame = buffer.m_130261_();
        if (frame == null) {
            frame = new CompoundTag();
        }
        int entitiesCount = buffer.readInt();
        ArrayList<UUID> entities = new ArrayList<UUID>();
        for (int i = 0; i < entitiesCount; ++i) {
            entities.add(buffer.m_130259_());
        }
        return new CameraInHandAddFrameC2SP(hand, frame, entities);
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack cameraStack = player.m_21120_(this.hand);
        Item item = cameraStack.m_41720_();
        if (!(item instanceof CameraItem)) {
            throw new IllegalStateException("Item in hand in not a Camera.");
        }
        CameraItem cameraItem = (CameraItem)item;
        cameraItem.addFrame(serverPlayer, cameraStack, this.hand, this.frame, this.getEntities(serverPlayer.m_9236_()));
        return true;
    }

    private List<Entity> getEntities(ServerLevel level) {
        ArrayList<Entity> entitiesInFrame = new ArrayList<Entity>();
        for (UUID uuid : this.entitiesInFrameIds) {
            @Nullable Entity entity = level.m_8791_(uuid);
            if (entity == null) continue;
            entitiesInFrame.add(entity);
        }
        return entitiesInFrame;
    }
}

