/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.modifiers;

import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import net.minecraft.util.Mth;

public class NegativeFilmPixelModifier
implements IPixelModifier {
    public final boolean simulateFilmTransparency;

    public NegativeFilmPixelModifier(boolean simulateFilmTransparency) {
        this.simulateFilmTransparency = simulateFilmTransparency;
    }

    @Override
    public String getIdSuffix() {
        return this.simulateFilmTransparency ? "_negative_film" : "_negative";
    }

    @Override
    public int modifyPixel(int ABGR) {
        int alpha = ABGR >> 24 & 0xFF;
        int blue = ABGR >> 16 & 0xFF;
        int green = ABGR >> 8 & 0xFF;
        int red = ABGR & 0xFF;
        if (this.simulateFilmTransparency) {
            int brightness = (blue + green + red) / 3;
            int opacity = (int)Mth.m_14036_((float)((float)brightness * 1.5f), (float)0.0f, (float)255.0f);
            alpha = alpha * opacity / 255;
        }
        blue = 255 - blue;
        green = 255 - green;
        red = 255 - red;
        return alpha << 24 | blue << 16 | green << 8 | red;
    }

    public String toString() {
        return "NegativeFilmPixelModifier{simulateTransparency=" + this.simulateFilmTransparency + "}";
    }
}

