/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.block.custom;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlockEntities;
import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.block.custom.ChunkCacheBlockEntity;
import com.cerbon.bosses_of_mass_destruction.block.custom.MonolithBlockEntity;
import com.cerbon.bosses_of_mass_destruction.capability.ChunkBlockCache;
import com.cerbon.bosses_of_mass_destruction.capability.util.BMDCapabilities;
import com.cerbon.bosses_of_mass_destruction.util.VanillaCopiesServer;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MonolithBlock
extends BaseEntityBlock {
    private static final VoxelShape xAxisShape = MonolithBlock.m_49796_((double)3.5, (double)0.0, (double)1.5, (double)12.5, (double)16.0, (double)14.5);
    private static final VoxelShape zAxisShape = MonolithBlock.m_49796_((double)1.5, (double)0.0, (double)3.5, (double)14.5, (double)16.0, (double)12.5);

    public MonolithBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER));
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.bosses_of_mass_destruction.monolith_block.tooltip_0").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.bosses_of_mass_destruction.monolith_block.tooltip_1").m_130940_(ChatFormatting.DARK_GRAY));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MonolithBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return MonolithBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BMDBlockEntities.MONOLITH_BLOCK_ENTITY.get()), ChunkCacheBlockEntity::tick);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_() == Direction.Axis.X ? xAxisShape : zAxisShape;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, @NotNull BlockState newState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos posFrom) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_((Property)BlockStateProperties.f_61401_);
        BlockState airState = Blocks.f_50016_.m_49966_();
        if (direction.m_122434_() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            if (newState.m_60713_((Block)this) && newState.m_61143_((Property)BlockStateProperties.f_61401_) != doubleBlockHalf) {
                return (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)newState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
            }
            return airState;
        }
        return super.m_7417_(state, direction, newState, level, pos, posFrom);
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            VanillaCopiesServer.onBreakInCreative(level, pos, state, player);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        if (blockPos.m_123342_() < 255 && ctx.m_43725_().m_8055_(blockPos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)ctx.m_8125_())).m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = level.m_8055_(blockPos);
        if (state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            return blockState.m_60783_((BlockGetter)level, blockPos, Direction.UP);
        }
        return blockState.m_60713_((Block)this);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))).m_61122_((Property)DoorBlock.f_52728_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61401_, HorizontalDirectionalBlock.f_54117_});
    }

    public static float getExplosionPower(ServerLevel level, BlockPos pos, float power) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Optional<ChunkBlockCache> blockCache = BMDCapabilities.getChunkBlockCache((Level)level);
        if (blockCache.isPresent()) {
            for (int x = chunkPos.f_45578_ - 4; x <= chunkPos.f_45578_ + 4; ++x) {
                for (int z = chunkPos.f_45579_ - 4; z <= chunkPos.f_45579_ + 4; ++z) {
                    List<BlockPos> blocks = blockCache.get().getBlocksFromChunk(new ChunkPos(x, z), (Block)BMDBlocks.MONOLITH_BLOCK.get());
                    for (BlockPos blockPos : blocks) {
                        if (Math.abs(blockPos.m_123341_() - pos.m_123341_()) >= 64 || Math.abs(blockPos.m_123342_() - pos.m_123342_()) >= 64 || Math.abs(blockPos.m_123343_() - pos.m_123343_()) >= 64) continue;
                        return power * 1.3f;
                    }
                }
            }
        }
        return power;
    }
}

