/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.event.EventScheduler;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.event.TimedEvent;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MathUtils;
import com.cerbon.bosses_of_mass_destruction.capability.util.BMDCapabilities;
import com.cerbon.bosses_of_mass_destruction.damagesource.UnshieldableDamageSource;
import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.RiftBurst;
import com.cerbon.bosses_of_mass_destruction.packet.BMDPacketHandler;
import com.cerbon.bosses_of_mass_destruction.packet.custom.SendDeltaMovementS2CPacket;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.bosses_of_mass_destruction.util.BMDUtils;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WaveAction
implements IActionWithCooldown {
    private final Mob entity;
    private final List<Vec3> circlePoints;
    private final Level level;
    private final EventScheduler eventScheduler;
    private final double riftRadius = 4.0;
    public static final int waveDelay = 20;
    public static final int attackStartDelay = 20;

    public WaveAction(Mob entity) {
        this.entity = entity;
        this.circlePoints = MathUtils.buildBlockCircle(4.0);
        this.level = entity.f_19853_;
        this.eventScheduler = BMDCapabilities.getLevelEventScheduler(this.level);
    }

    @Override
    public int perform() {
        LivingEntity target = this.entity.m_5448_();
        this.placeRifts(target);
        return 80;
    }

    private void placeRifts(LivingEntity target) {
        RiftBurst riftBurst = new RiftBurst((LivingEntity)this.entity, (ServerLevel)this.level, (ParticleOptions)BMDParticles.OBSIDILITH_WAVE_INDICATOR.get(), (ParticleOptions)BMDParticles.OBSIDILITH_WAVE.get(), 20, this.eventScheduler, this::damageEntity);
        BMDUtils.playSound((ServerLevel)this.level, this.entity.m_20182_(), (SoundEvent)BMDSounds.OBSIDILITH_PREPARE_ATTACK.get(), SoundSource.HOSTILE, 3.0f, 0.8f, 64.0, null);
        this.eventScheduler.addEvent(new TimedEvent(() -> {
            Vec3 direction = MathUtils.unNormedDirection(this.entity.m_20182_(), target.m_20182_()).m_82541_().m_82490_(4.0);
            int numRifts = 5;
            Vec3 startRiftPos = this.entity.m_20182_().m_82549_(direction);
            Vec3 endRiftPos = startRiftPos.m_82549_(direction.m_82490_((double)numRifts * 1.5));
            MathUtils.lineCallback(startRiftPos, endRiftPos, numRifts, (linePos, i) -> this.eventScheduler.addEvent(new TimedEvent(() -> {
                BMDUtils.playSound((ServerLevel)this.level, linePos, (SoundEvent)BMDSounds.WAVE_INDICATOR.get(), SoundSource.HOSTILE, 0.7f, 32.0, null);
                this.eventScheduler.addEvent(new TimedEvent(() -> BMDUtils.playSound((ServerLevel)this.level, linePos, (SoundEvent)BMDSounds.OBSIDILITH_WAVE.get(), SoundSource.HOSTILE, 1.2f, 32.0, null), 20, 1, () -> !this.entity.m_6084_()));
                for (Vec3 point : this.circlePoints) {
                    riftBurst.tryPlaceRift(linePos.m_82549_(point));
                }
            }, i * 8, 1, () -> !this.entity.m_6084_())));
        }, 20, 1, () -> !this.entity.m_6084_()));
    }

    private void damageEntity(LivingEntity livingEntity) {
        float damage = (float)this.entity.m_21133_(Attributes.f_22281_);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            BMDPacketHandler.sendToPlayer(new SendDeltaMovementS2CPacket(new Vec3(livingEntity.m_20184_().f_82479_, 0.8, livingEntity.m_20184_().f_82481_)), serverPlayer);
        }
        livingEntity.m_20254_(5);
        livingEntity.m_6469_((DamageSource)new UnshieldableDamageSource((Entity)this.entity), damage);
    }
}

