/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MathUtils;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.VecUtils;
import com.cerbon.bosses_of_mass_destruction.structure.util.IStructurePiece;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.ICaveDecorator;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;

public class SpikeCaveDecorator
implements ICaveDecorator {
    private final int bottomOfWorld;
    private final RandomSource random;
    private final List<BlockPos> spikePositions = new ArrayList<BlockPos>();
    private final List<Vec3> baseBlocks = MathUtils.buildBlockCircle(4.2);

    public SpikeCaveDecorator(int bottomOfWorld, RandomSource random) {
        this.bottomOfWorld = bottomOfWorld;
        this.random = random;
    }

    @Override
    public void onBlockPlaced(BlockPos pos, Block block) {
        double spikeSpacing = Math.pow((double)this.random.m_188503_(20) + 10.0, 2.0);
        if (pos.m_123342_() == 5 + this.bottomOfWorld && block != Blocks.f_50016_ && this.spikePositions.stream().allMatch(it -> it.m_123331_((Vec3i)pos) > spikeSpacing)) {
            this.spikePositions.add(pos);
        }
    }

    @Override
    public void generate(WorldGenLevel level, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, BlockPos pos, IStructurePiece structurePiece) {
        Map<Pair, List<BlockPos>> groupedSpikePositions = this.spikePositions.stream().collect(Collectors.groupingBy(p -> new Pair((Object)(p.m_123341_() >> 2), (Object)(p.m_123343_() >> 2))));
        List<BlockPos> spacesSpikePositions = groupedSpikePositions.values().stream().map(list -> (BlockPos)list.get(0)).toList();
        for (BlockPos outerPos : spacesSpikePositions) {
            Vec3 centerDirection = VecUtils.planeProject(VecUtils.asVec3(pos.m_121996_((Vec3i)outerPos)), VecUtils.yAxis).m_82541_();
            Vec3 tip = centerDirection.m_82490_((double)(5 + random.m_188503_(3))).m_82549_(VecUtils.yAxis.m_82490_((double)(7 + random.m_188503_(5))));
            this.generateSpike(outerPos, outerPos.m_121955_((Vec3i)new BlockPos(tip)), structurePiece, level, boundingBox, centerDirection);
        }
    }

    private void generateSpike(BlockPos origin, BlockPos tip, IStructurePiece structurePiece, WorldGenLevel level, BoundingBox boundingBox, Vec3 centerDirection) {
        List<BlockPos> blocksInLine;
        Vec3 centerDirectionPos = centerDirection.m_82490_(3.0);
        Set blockSet = this.baseBlocks.stream().map(BlockPos::new).collect(Collectors.toSet());
        Set innerBlockSet = blockSet.stream().filter(pos -> pos.m_203193_((Position)centerDirectionPos) < Math.pow(2.0, 2.0)).collect(Collectors.toSet());
        Set middleBlockSet = blockSet.stream().filter(block -> !innerBlockSet.contains(block)).filter(block -> block.m_203193_((Position)centerDirectionPos) < Math.pow(3.7, 2.0)).collect(Collectors.toSet());
        Set outerBlockSet = blockSet.stream().filter(pos -> !middleBlockSet.contains(pos) && !innerBlockSet.contains(pos)).collect(Collectors.toSet());
        for (BlockPos blockPos : innerBlockSet) {
            blocksInLine = MathUtils.getBlocksInLine(blockPos.m_121955_((Vec3i)origin), tip);
            for (BlockPos pos2 : blocksInLine) {
                BlockState blockState = this.random.m_188503_(16) == 0 ? Blocks.f_152491_.m_49966_() : Blocks.f_152490_.m_49966_();
                structurePiece.placeBlock(level, blockState, pos2, boundingBox);
            }
        }
        for (BlockPos blockPos : middleBlockSet) {
            blocksInLine = MathUtils.getBlocksInLine(blockPos.m_121955_((Vec3i)origin), tip);
            for (BlockPos pos2 : blocksInLine) {
                structurePiece.placeBlock(level, Blocks.f_152497_.m_49966_(), pos2, boundingBox);
            }
        }
        for (BlockPos blockPos : outerBlockSet) {
            blocksInLine = MathUtils.getBlocksInLine(blockPos.m_121955_((Vec3i)origin), tip);
            for (BlockPos pos2 : blocksInLine) {
                structurePiece.placeBlock(level, Blocks.f_152597_.m_49966_(), pos2, boundingBox);
            }
        }
    }
}

